/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.service;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Calendar;
import org.hippoecm.hst.provider.ValueProvider;
import org.hippoecm.hst.service.Service;
import org.hippoecm.hst.service.ServiceBeanAccessProvider;
import org.hippoecm.hst.service.UnderlyingServiceAware;

public class ServiceBeanAccessProviderImpl
implements ServiceBeanAccessProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String HST_SERVICE_NAMESPACE_SEPARATOR = ":";
    protected Service service;
    protected ValueProvider valueProvider;

    public ServiceBeanAccessProviderImpl(Service service) throws IllegalAccessException, NoSuchFieldException {
        this.service = service;
        this.valueProvider = this.service.getValueProvider();
    }

    public Object getProperty(String namespacePrefix, String name, Class returnType, Method method) {
        String nodePropName;
        if (UnderlyingServiceAware.class == method.getDeclaringClass()) {
            return this.service;
        }
        String string = nodePropName = namespacePrefix != null ? namespacePrefix + HST_SERVICE_NAMESPACE_SEPARATOR + name : name;
        if (returnType != null && !returnType.isArray()) {
            if (returnType == String.class) {
                return this.valueProvider.getString(nodePropName);
            }
            if (returnType == Boolean.TYPE || returnType == Boolean.class) {
                return this.valueProvider.getBoolean(nodePropName);
            }
            if (returnType == Long.TYPE || returnType == Long.class) {
                return this.valueProvider.getLong(nodePropName);
            }
            if (returnType == Double.TYPE || returnType == Double.class) {
                return this.valueProvider.getDouble(nodePropName);
            }
            if (returnType == Calendar.class) {
                return this.valueProvider.getDate(nodePropName);
            }
        } else {
            if (returnType == String[].class) {
                return this.valueProvider.getStrings(nodePropName);
            }
            if (returnType == boolean[].class || returnType == Boolean[].class) {
                return this.valueProvider.getBooleans(nodePropName);
            }
            if (returnType == long[].class || returnType == Long[].class) {
                return this.valueProvider.getLongs(nodePropName);
            }
            if (returnType == double[].class || returnType == Double[].class) {
                return this.valueProvider.getDoubles(nodePropName);
            }
            if (returnType == Calendar[].class) {
                return this.valueProvider.getDates(nodePropName);
            }
        }
        return this.valueProvider.getProperties().get(nodePropName);
    }

    public Object setProperty(String namespacePrefix, String name, Object value, Class returnType, Method method) {
        if (UnderlyingServiceAware.class == method.getDeclaringClass()) {
            this.service = (Service)value;
            return null;
        }
        String nodePropName = namespacePrefix != null ? namespacePrefix + HST_SERVICE_NAMESPACE_SEPARATOR + name : name;
        this.service.getValueProvider().getProperties().put(nodePropName, value);
        return null;
    }

    public Object invoke(String namespacePrefix, String name, Object[] args, Class returnType, Method method) {
        throw new UnsupportedOperationException("Service value provider does not support invocation on operations.");
    }
}

