/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.service;

import java.io.Serializable;
import javax.jcr.Node;
import org.hippoecm.hst.provider.jcr.JCRValueProvider;
import org.hippoecm.hst.provider.jcr.JCRValueProviderImpl;
import org.hippoecm.hst.service.Service;
import org.hippoecm.hst.service.jcr.JCRService;

public abstract class AbstractJCRService
implements JCRService,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient JCRValueProvider valueProvider;

    public AbstractJCRService(Node jcrNode) {
        this.valueProvider = new JCRValueProviderImpl(jcrNode);
    }

    public JCRValueProvider getValueProvider() {
        return this.valueProvider;
    }

    public void closeValueProvider(boolean closeChildServices) {
        if (closeChildServices && this.getChildServices() != null) {
            for (Service s : this.getChildServices()) {
                if (s == null) continue;
                s.closeValueProvider(closeChildServices);
            }
        }
        if (this.valueProvider != null) {
            this.valueProvider.detach();
        }
    }
}

