/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.proxy;

import java.util.Set;
import org.apache.commons.proxy.Interceptor;
import org.apache.commons.proxy.Invocation;
import org.hippoecm.hst.content.beans.Node;
import org.hippoecm.hst.proxy.NamespacedBeanMethodInvoker;
import org.hippoecm.hst.proxy.ProxyFactory;
import org.hippoecm.hst.service.ServiceBeanAccessProvider;

public class ProxyUtils {
    private ProxyUtils() {
    }

    public static Object createdUnsupportableProxyObject(Object target, final Set<String> unsupportedMethodNames, Class ... proxyInterfaces) {
        ProxyFactory factory = new ProxyFactory();
        Interceptor interceptor = new Interceptor(){

            public Object intercept(Invocation invocation) throws Throwable {
                if (unsupportedMethodNames.contains(invocation.getMethod().getName())) {
                    throw new UnsupportedOperationException("Unsupported operation: " + invocation.getMethod().getName());
                }
                return invocation.proceed();
            }
        };
        return factory.createInterceptorProxy(target.getClass().getClassLoader(), target, interceptor, proxyInterfaces);
    }

    public static Object createBeanAccessProviderProxy(ServiceBeanAccessProvider provider, Class ... proxyInterfacesOrDelegateeClass) {
        ProxyFactory factory = new ProxyFactory();
        String primaryJcrType = ProxyUtils.findPrimaryJcrType(proxyInterfacesOrDelegateeClass);
        NamespacedBeanMethodInvoker invoker = new NamespacedBeanMethodInvoker(provider, primaryJcrType);
        Class[] proxyInterfaces = null;
        proxyInterfaces = proxyInterfacesOrDelegateeClass.length == 1 && !proxyInterfacesOrDelegateeClass[0].isInterface() ? proxyInterfacesOrDelegateeClass[0].getInterfaces() : proxyInterfacesOrDelegateeClass;
        return factory.createInvokerProxy(proxyInterfaces[0].getClassLoader(), invoker, proxyInterfaces);
    }

    private static String findPrimaryJcrType(Class[] proxyInterfaces) {
        String primaryJcrType = null;
        for (Class proxyInterface : proxyInterfaces) {
            if (!proxyInterface.isAnnotationPresent(Node.class)) continue;
            primaryJcrType = proxyInterface.getAnnotation(Node.class).jcrType();
            break;
        }
        if (primaryJcrType == null) {
            Class[] extendingInterfaces;
            Class proxyInterface;
            Class[] arr$ = proxyInterfaces;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && ((extendingInterfaces = (proxyInterface = arr$[i$]).getInterfaces()).length <= 0 || (primaryJcrType = ProxyUtils.findPrimaryJcrType(extendingInterfaces)) == null); ++i$) {
            }
        }
        return primaryJcrType;
    }
}

