/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.proxy;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.proxy.Interceptor;
import org.apache.commons.proxy.Invocation;
import org.apache.commons.proxy.Invoker;
import org.apache.commons.proxy.ObjectProvider;

public class ProxyFactory
extends org.apache.commons.proxy.ProxyFactory {
    public Object createDelegatorProxy(ClassLoader classLoader, ObjectProvider delegateProvider, Class[] proxyClasses) {
        return Proxy.newProxyInstance(classLoader, proxyClasses, (InvocationHandler)new DelegatorInvocationHandler(delegateProvider));
    }

    public Object createInterceptorProxy(ClassLoader classLoader, Object target, Interceptor interceptor, Class[] proxyClasses) {
        return Proxy.newProxyInstance(classLoader, proxyClasses, (InvocationHandler)new InterceptorInvocationHandler(target, interceptor));
    }

    public Object createInvokerProxy(ClassLoader classLoader, Invoker invoker, Class[] proxyClasses) {
        return Proxy.newProxyInstance(classLoader, proxyClasses, (InvocationHandler)new InvokerInvocationHandler(invoker));
    }

    protected static boolean isHashCode(Method method) {
        return "hashCode".equals(method.getName()) && Integer.TYPE.equals(method.getReturnType()) && method.getParameterTypes().length == 0;
    }

    protected static boolean isEqualsMethod(Method method) {
        return "equals".equals(method.getName()) && Boolean.TYPE.equals(method.getReturnType()) && method.getParameterTypes().length == 1 && Object.class.equals(method.getParameterTypes()[0]);
    }

    private static class ReflectionInvocation
    implements Invocation,
    Serializable {
        private static final long serialVersionUID = 1L;
        private transient Method method;
        private transient Object[] arguments;
        private transient Object target;

        public ReflectionInvocation(Object target, Method method, Object[] arguments) {
            this.method = method;
            this.arguments = arguments == null ? ArrayUtils.EMPTY_OBJECT_ARRAY : arguments;
            this.target = target;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getProxy() {
            return this.target;
        }

        public Object proceed() throws Throwable {
            try {
                return this.method.invoke(this.target, this.arguments);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    private static class InvokerInvocationHandler
    extends AbstractInvocationHandler {
        private static final long serialVersionUID = 1L;
        private final Invoker invoker;

        public InvokerInvocationHandler(Invoker invoker) {
            this.invoker = invoker;
        }

        @Override
        public Object invokeImpl(Object proxy, Method method, Object[] args) throws Throwable {
            return this.invoker.invoke(proxy, method, args);
        }
    }

    private static abstract class AbstractInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = 1L;

        private AbstractInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (ProxyFactory.isHashCode(method)) {
                return System.identityHashCode(proxy);
            }
            if (ProxyFactory.isEqualsMethod(method)) {
                return proxy == args[0];
            }
            return this.invokeImpl(proxy, method, args);
        }

        protected abstract Object invokeImpl(Object var1, Method var2, Object[] var3) throws Throwable;
    }

    private static class InterceptorInvocationHandler
    extends AbstractInvocationHandler {
        private static final long serialVersionUID = 1L;
        private final Object target;
        private final Interceptor methodInterceptor;

        public InterceptorInvocationHandler(Object target, Interceptor methodInterceptor) {
            this.target = target;
            this.methodInterceptor = methodInterceptor;
        }

        @Override
        public Object invokeImpl(Object proxy, Method method, Object[] args) throws Throwable {
            ReflectionInvocation invocation = new ReflectionInvocation(this.target, method, args);
            return this.methodInterceptor.intercept((Invocation)invocation);
        }
    }

    private static class DelegatorInvocationHandler
    extends AbstractInvocationHandler {
        private static final long serialVersionUID = 1L;
        private final ObjectProvider delegateProvider;

        protected DelegatorInvocationHandler(ObjectProvider delegateProvider) {
            this.delegateProvider = delegateProvider;
        }

        @Override
        public Object invokeImpl(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.delegateProvider.getObject(), args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

