/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.commons.proxy.Invoker;
import org.hippoecm.hst.content.beans.Node;
import org.hippoecm.hst.service.ServiceBeanAccessProvider;

public class NamespacedBeanMethodInvoker
implements Invoker,
Serializable {
    private static final long serialVersionUID = 1L;
    private ServiceBeanAccessProvider provider;
    private String primaryJcrType;
    private String namespacePrefix;

    public NamespacedBeanMethodInvoker(ServiceBeanAccessProvider provider, String primaryJcrType) {
        this.provider = provider;
        this.primaryJcrType = primaryJcrType;
        int offset = primaryJcrType.indexOf(58);
        this.namespacePrefix = offset != -1 ? primaryJcrType.substring(0, offset) : primaryJcrType;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int offset;
        String overridenPrimaryJcrType = this.getOverridenPrimaryJcrType(method);
        String overridenNamespacePrefix = null;
        overridenNamespacePrefix = this.primaryJcrType.equals(overridenPrimaryJcrType) ? this.namespacePrefix : ((offset = overridenPrimaryJcrType.indexOf(59)) != -1 ? overridenPrimaryJcrType.substring(0, offset) : overridenPrimaryJcrType);
        String methodName = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        if (methodName.startsWith("get") && paramTypes.length == 0) {
            String propName = NamespacedBeanMethodInvoker.getCamelString(methodName.substring(3));
            return this.provider.getProperty(overridenNamespacePrefix, propName, returnType, method);
        }
        if (methodName.startsWith("is") && paramTypes.length == 0 && (returnType == Boolean.TYPE || returnType == Boolean.class)) {
            String propName = NamespacedBeanMethodInvoker.getCamelString(methodName.substring(2));
            return this.provider.getProperty(overridenNamespacePrefix, propName, returnType, method);
        }
        if (methodName.startsWith("set") && paramTypes.length == 1) {
            String propName = NamespacedBeanMethodInvoker.getCamelString(methodName.substring(3));
            return this.provider.setProperty(overridenNamespacePrefix, propName, args[0], returnType, method);
        }
        return this.provider.invoke(overridenNamespacePrefix, methodName, args, returnType, method);
    }

    private String getOverridenPrimaryJcrType(Method method) {
        String overridenPrimaryJcrType = this.primaryJcrType;
        if (method.isAnnotationPresent(Node.class)) {
            overridenPrimaryJcrType = method.getAnnotation(Node.class).jcrType();
        } else if (method.getDeclaringClass().isAnnotationPresent(Node.class)) {
            overridenPrimaryJcrType = method.getDeclaringClass().getAnnotation(Node.class).jcrType();
        }
        return overridenPrimaryJcrType;
    }

    private static String getCamelString(String s) {
        char firstChar = s.charAt(0);
        if (Character.isUpperCase(firstChar)) {
            StringBuilder sb = new StringBuilder(s);
            sb.setCharAt(0, Character.toLowerCase(firstChar));
            s = sb.toString();
        }
        return s;
    }
}

