/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.provider.jcr;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hippoecm.hst.core.internal.CollectionOptimizer;
import org.hippoecm.hst.provider.PropertyMap;

class PropertyMapImpl
implements PropertyMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Boolean> booleans = Collections.emptyMap();
    private Map<String, Boolean[]> booleanArrays = Collections.emptyMap();
    private Map<String, String> strings = Collections.emptyMap();
    private Map<String, String[]> stringArrays = Collections.emptyMap();
    private Map<String, Double> doubles = Collections.emptyMap();
    private Map<String, Double[]> doubleArrays = Collections.emptyMap();
    private Map<String, Long> longs = Collections.emptyMap();
    private Map<String, Long[]> longArrays = Collections.emptyMap();
    private Map<String, Calendar> calendars = Collections.emptyMap();
    private Map<String, Calendar[]> calendarArrays = Collections.emptyMap();
    private Set<String> availableProps = Collections.emptySet();
    private Set<String> unAvailableProps = Collections.emptySet();

    PropertyMapImpl() {
    }

    boolean hasProperty(String name) {
        return this.availableProps.contains(name);
    }

    void addAvailableProperty(String name) {
        if (this.availableProps == Collections.EMPTY_SET) {
            this.availableProps = new HashSet<String>();
        }
        this.availableProps.add(name);
    }

    boolean isUnAvailableProperty(String name) {
        return this.unAvailableProps.contains(name);
    }

    void addUnAvailableProperty(String name) {
        if (this.unAvailableProps == Collections.EMPTY_SET) {
            this.unAvailableProps = new HashSet<String>();
        }
        this.unAvailableProps.add(name);
    }

    public Map<String, Boolean[]> getBooleanArrays() {
        return this.booleanArrays;
    }

    void put(String name, Boolean[] booleanArray) {
        if (this.booleanArrays == Collections.EMPTY_MAP) {
            this.booleanArrays = new HashMap<String, Boolean[]>();
        }
        this.booleanArrays.put(name, booleanArray);
    }

    public Map<String, Boolean> getBooleans() {
        return this.booleans;
    }

    void put(String name, Boolean b) {
        if (this.booleans == Collections.EMPTY_MAP) {
            this.booleans = new HashMap<String, Boolean>();
        }
        this.booleans.put(name, b);
    }

    public Map<String, Calendar[]> getCalendarArrays() {
        return this.calendarArrays;
    }

    void put(String name, Calendar[] calendarArray) {
        if (this.calendarArrays == Collections.EMPTY_MAP) {
            this.calendarArrays = new HashMap<String, Calendar[]>();
        }
        this.calendarArrays.put(name, calendarArray);
    }

    public Map<String, Calendar> getCalendars() {
        return this.calendars;
    }

    void put(String name, Calendar calendar) {
        if (this.calendars == Collections.EMPTY_MAP) {
            this.calendars = new HashMap<String, Calendar>();
        }
        this.calendars.put(name, calendar);
    }

    public Map<String, Double[]> getDoubleArrays() {
        return this.doubleArrays;
    }

    void put(String name, Double[] doubleArray) {
        if (this.doubleArrays == Collections.EMPTY_MAP) {
            this.doubleArrays = new HashMap<String, Double[]>();
        }
        this.doubleArrays.put(name, doubleArray);
    }

    public Map<String, Double> getDoubles() {
        return this.doubles;
    }

    void put(String name, Double d) {
        if (this.doubles == Collections.EMPTY_MAP) {
            this.doubles = new HashMap<String, Double>();
        }
        this.doubles.put(name, d);
    }

    public Map<String, Long[]> getLongArrays() {
        return this.longArrays;
    }

    void put(String name, Long[] longArray) {
        if (this.longArrays == Collections.EMPTY_MAP) {
            this.longArrays = new HashMap<String, Long[]>();
        }
        this.longArrays.put(name, longArray);
    }

    public Map<String, Long> getLongs() {
        return this.longs;
    }

    void put(String name, Long l) {
        if (this.longs == Collections.EMPTY_MAP) {
            this.longs = new HashMap<String, Long>();
        }
        this.longs.put(name, l);
    }

    public Map<String, String[]> getStringArrays() {
        return this.stringArrays;
    }

    void put(String name, String[] stringArray) {
        if (this.stringArrays == Collections.EMPTY_MAP) {
            this.stringArrays = new HashMap<String, String[]>();
        }
        this.stringArrays.put(name, stringArray);
    }

    public Map<String, String> getStrings() {
        return this.strings;
    }

    void put(String name, String s) {
        if (this.strings == Collections.EMPTY_MAP) {
            this.strings = new HashMap<String, String>();
        }
        this.strings.put(name, s);
    }

    public Map<String, Object> getAllMapsCombined() {
        HashMap<String, Object> combined = new HashMap<String, Object>(){
            private static final long serialVersionUID = 1L;

            @Override
            public void putAll(Map<? extends String, ? extends Object> m) {
                if (m == null) {
                    return;
                }
                super.putAll(m);
            }
        };
        combined.putAll(this.booleanArrays);
        combined.putAll(this.booleans);
        for (Map.Entry<String, Calendar[]> entry : this.calendarArrays.entrySet()) {
            combined.put(entry.getKey(), entry.getValue().clone());
        }
        for (Map.Entry<String, Object> entry : this.calendars.entrySet()) {
            combined.put(entry.getKey(), ((Calendar)entry.getValue()).clone());
        }
        combined.putAll(this.doubleArrays);
        combined.putAll(this.doubles);
        combined.putAll(this.longArrays);
        combined.putAll(this.longs);
        combined.putAll(this.stringArrays);
        combined.putAll(this.strings);
        return combined;
    }

    public void flush() {
        this.availableProps.clear();
        this.booleanArrays.clear();
        this.booleans.clear();
        this.calendarArrays.clear();
        this.calendars.clear();
        this.doubleArrays.clear();
        this.doubles.clear();
        this.longArrays.clear();
        this.longs.clear();
        this.stringArrays.clear();
        this.strings.clear();
    }

    void providerDetached() {
        this.booleans = CollectionOptimizer.optimizeHashMap(this.booleans);
        this.booleanArrays = CollectionOptimizer.optimizeHashMap(this.booleanArrays);
        this.strings = CollectionOptimizer.optimizeHashMap(this.strings);
        this.stringArrays = CollectionOptimizer.optimizeHashMap(this.stringArrays);
        this.doubles = CollectionOptimizer.optimizeHashMap(this.doubles);
        this.doubleArrays = CollectionOptimizer.optimizeHashMap(this.doubleArrays);
        this.longs = CollectionOptimizer.optimizeHashMap(this.longs);
        this.longArrays = CollectionOptimizer.optimizeHashMap(this.longArrays);
        this.calendars = CollectionOptimizer.optimizeHashMap(this.calendars);
        this.calendarArrays = CollectionOptimizer.optimizeHashMap(this.calendarArrays);
        this.availableProps = CollectionOptimizer.optimizeHashSet(this.availableProps);
        this.unAvailableProps = CollectionOptimizer.optimizeHashSet(this.unAvailableProps);
    }
}

