/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.provider.jcr;

import java.util.Calendar;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.ArrayUtils;
import org.hippoecm.hst.core.internal.StringPool;
import org.hippoecm.hst.core.jcr.RuntimeRepositoryException;
import org.hippoecm.hst.provider.PropertyMap;
import org.hippoecm.hst.provider.jcr.JCRValueProvider;
import org.hippoecm.hst.provider.jcr.PropertyMapImpl;
import org.hippoecm.repository.api.HippoNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRValueProviderImpl
implements JCRValueProvider {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(JCRValueProviderImpl.class);
    private static final Calendar[] EMPTY_CALENDAR_ARRAY = new Calendar[0];
    private transient Node jcrNode;
    private String nodePath;
    private String canonicalPath;
    private String identifier;
    private String nodeName;
    private String localizedName;
    private boolean detached = false;
    private boolean isLoaded = false;
    private boolean useStringPool = false;
    private PropertyMapImpl propertyMap = new PropertyMapImpl();

    public JCRValueProviderImpl(Node jcrNode) {
        this(jcrNode, true, false);
    }

    public JCRValueProviderImpl(Node jcrNode, boolean lazyLoading) {
        this(jcrNode, lazyLoading, false);
    }

    public JCRValueProviderImpl(Node jcrNode, boolean lazyLoading, boolean useStringPool) {
        this.jcrNode = jcrNode;
        this.useStringPool = useStringPool;
        if (jcrNode == null) {
            return;
        }
        try {
            this.nodeName = this.stringPool(jcrNode.getName());
            this.nodePath = jcrNode.getPath();
            if (!lazyLoading) {
                this.populate();
                this.populateCanonicalPath();
                this.populateIdentifier();
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e);
        }
    }

    public Node getJcrNode() {
        if (this.isDetached()) {
            log.warn("Node '{}' is detached. Return null", (Object)this.nodePath);
            return null;
        }
        return this.jcrNode;
    }

    public Node getParentJcrNode() {
        if (this.jcrNode == null) {
            log.warn("Cannot get parent node when node is detached");
            return null;
        }
        try {
            if (this.jcrNode.isSame((Item)this.jcrNode.getSession().getRootNode())) {
                log.warn("Cannot get parent node for the jcr rootNode");
                return null;
            }
            return this.jcrNode.getParent();
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e);
        }
    }

    public void detach() {
        if (this.nodePath != null) {
            log.debug("Detaching node '{}'", (Object)this.nodePath);
        }
        this.detached = true;
        this.jcrNode = null;
        this.propertyMap.providerDetached();
    }

    public boolean isDetached() {
        return this.detached;
    }

    public String getName() {
        return this.nodeName;
    }

    public String getLocalizedName() {
        if (this.localizedName != null) {
            return this.localizedName;
        }
        Node node = this.getJcrNode();
        if (!(node instanceof HippoNode)) {
            this.localizedName = this.getName();
            return this.localizedName;
        }
        try {
            this.localizedName = ((HippoNode)node).getLocalizedName();
            return this.localizedName;
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e);
        }
    }

    public String getPath() {
        return this.nodePath;
    }

    public String getCanonicalPath() {
        if (this.canonicalPath != null) {
            return this.canonicalPath;
        }
        this.populateCanonicalPath();
        return this.canonicalPath;
    }

    public String getIdentifier() {
        if (this.identifier != null) {
            return this.identifier;
        }
        this.populateIdentifier();
        return this.identifier;
    }

    public boolean isNodeType(String nodeType) {
        if (this.isDetached()) {
            log.warn("Jcr Node is detatched. Cannot execute method");
            return false;
        }
        try {
            return this.jcrNode.isNodeType(nodeType);
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e);
        }
    }

    public boolean hasProperty(String propertyName) {
        boolean b = this.propertyMap.hasProperty(propertyName);
        if (b) {
            return true;
        }
        if (this.isLoaded) {
            return false;
        }
        b = this.propertyMap.isUnAvailableProperty(propertyName);
        if (b) {
            return false;
        }
        if (this.isDetached()) {
            log.warn("Jcr Node is detatched. Cannot execute method");
            return false;
        }
        try {
            boolean bool = this.jcrNode.hasProperty(propertyName);
            if (bool) {
                Property prop = this.jcrNode.getProperty(propertyName);
                PropertyDefinition propDef = prop.getDefinition();
                this.loadProperty(prop, propDef, propertyName);
            } else {
                this.propertyMap.addUnAvailableProperty(this.stringPool(propertyName));
            }
            return bool;
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e);
        }
    }

    public String getString(String propertyName) {
        String o = this.propertyMap.getStrings().get(propertyName);
        if (o != null) {
            return o;
        }
        if (this.propertyMap.isUnAvailableProperty(propertyName)) {
            return null;
        }
        this.loadProperty(propertyName, 1, false);
        return this.propertyMap.getStrings().get(propertyName);
    }

    public String[] getStrings(String propertyName) {
        String[] o = this.propertyMap.getStringArrays().get(propertyName);
        if (o != null) {
            return o;
        }
        if (this.propertyMap.isUnAvailableProperty(propertyName)) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        this.loadProperty(propertyName, 1, true);
        String[] val = this.propertyMap.getStringArrays().get(propertyName);
        if (val == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return val;
    }

    public Double getDouble(String propertyName) {
        Double o = this.propertyMap.getDoubles().get(propertyName);
        if (o != null) {
            return o;
        }
        if (this.propertyMap.isUnAvailableProperty(propertyName)) {
            return 0.0;
        }
        this.loadProperty(propertyName, 4, false);
        o = this.propertyMap.getDoubles().get(propertyName);
        if (o == null) {
            return 0.0;
        }
        return o;
    }

    public Double[] getDoubles(String propertyName) {
        Double[] o = this.propertyMap.getDoubleArrays().get(propertyName);
        if (o != null) {
            return o;
        }
        if (this.propertyMap.isUnAvailableProperty(propertyName)) {
            return ArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        this.loadProperty(propertyName, 4, true);
        Double[] val = this.propertyMap.getDoubleArrays().get(propertyName);
        if (val == null) {
            return ArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        return val;
    }

    public Long getLong(String propertyName) {
        Long o = this.propertyMap.getLongs().get(propertyName);
        if (o != null) {
            return o;
        }
        if (this.propertyMap.isUnAvailableProperty(propertyName)) {
            return 0L;
        }
        this.loadProperty(propertyName, 3, false);
        o = this.propertyMap.getLongs().get(propertyName);
        if (o == null) {
            return 0L;
        }
        return o;
    }

    public Long[] getLongs(String propertyName) {
        Long[] o = this.propertyMap.getLongArrays().get(propertyName);
        if (o != null) {
            return o;
        }
        if (this.propertyMap.isUnAvailableProperty(propertyName)) {
            return ArrayUtils.EMPTY_LONG_OBJECT_ARRAY;
        }
        this.loadProperty(propertyName, 3, true);
        Long[] val = this.propertyMap.getLongArrays().get(propertyName);
        if (val == null) {
            return ArrayUtils.EMPTY_LONG_OBJECT_ARRAY;
        }
        return val;
    }

    public Calendar getDate(String propertyName) {
        Calendar o = this.propertyMap.getCalendars().get(propertyName);
        if (o != null) {
            return (Calendar)o.clone();
        }
        if (this.propertyMap.isUnAvailableProperty(propertyName)) {
            return null;
        }
        this.loadProperty(propertyName, 5, false);
        return this.propertyMap.getCalendars().get(propertyName);
    }

    public Calendar[] getDates(String propertyName) {
        Calendar[] o = this.propertyMap.getCalendarArrays().get(propertyName);
        if (o != null) {
            return (Calendar[])o.clone();
        }
        if (this.propertyMap.isUnAvailableProperty(propertyName)) {
            return EMPTY_CALENDAR_ARRAY;
        }
        this.loadProperty(propertyName, 5, true);
        Calendar[] val = this.propertyMap.getCalendarArrays().get(propertyName);
        if (val == null) {
            return EMPTY_CALENDAR_ARRAY;
        }
        return val;
    }

    public Boolean getBoolean(String propertyName) {
        Boolean o = this.propertyMap.getBooleans().get(propertyName);
        if (o != null) {
            return o;
        }
        if (this.propertyMap.isUnAvailableProperty(propertyName)) {
            return false;
        }
        this.loadProperty(propertyName, 6, false);
        o = this.propertyMap.getBooleans().get(propertyName);
        if (o == null) {
            return false;
        }
        return o;
    }

    public Boolean[] getBooleans(String propertyName) {
        Boolean[] o = this.propertyMap.getBooleanArrays().get(propertyName);
        if (o != null) {
            return o;
        }
        if (this.propertyMap.isUnAvailableProperty(propertyName)) {
            return ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        this.loadProperty(propertyName, 6, true);
        Boolean[] val = this.propertyMap.getBooleanArrays().get(propertyName);
        if (val == null) {
            return ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        return val;
    }

    public Map<String, Object> getProperties() {
        PropertyMap p = this.getPropertyMap();
        return p.getAllMapsCombined();
    }

    public PropertyMap getPropertyMap() {
        if (this.isLoaded) {
            return this.propertyMap;
        }
        this.populate();
        return this.propertyMap;
    }

    private void loadProperty(String propertyName, int propertyType, boolean isMultiple) {
        if (this.isLoaded) {
            return;
        }
        if (this.isDetached()) {
            log.warn("Jcr Node is detatched. Cannot execute method");
            return;
        }
        try {
            if (this.jcrNode.hasProperty(propertyName)) {
                Property prop = this.jcrNode.getProperty(propertyName);
                if (prop.getType() != propertyType) {
                    if (log.isWarnEnabled()) {
                        log.warn("Cannot return property '{}' for node '{}' because it is of the wrong type. Return null", (Object)propertyName, (Object)this.nodePath);
                    }
                    return;
                }
                PropertyDefinition propDef = prop.getDefinition();
                if (propDef.isMultiple() && isMultiple || !propDef.isMultiple() && !isMultiple) {
                    this.loadProperty(this.jcrNode.getProperty(propertyName), propDef, propertyName);
                    return;
                }
                if (log.isWarnEnabled()) {
                    log.warn("Cannot return property '{}' for node '{}'. Return null", (Object)propertyName, (Object)this.nodePath);
                }
                return;
            }
            this.propertyMap.addUnAvailableProperty(this.stringPool(propertyName));
            log.debug("Property '{}' not found at '{}'.Return null", (Object)propertyName, (Object)this.nodePath);
            return;
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e);
        }
    }

    private void loadProperty(Property p, PropertyDefinition propDef, String propertyName) {
        propertyName = this.stringPool(propertyName);
        try {
            switch (p.getType()) {
                case 6: {
                    if (propDef.isMultiple()) {
                        Value[] values = p.getValues();
                        Boolean[] bools = new Boolean[values.length];
                        int i = 0;
                        for (Value val : values) {
                            bools[i] = val.getBoolean();
                            ++i;
                        }
                        this.propertyMap.put(propertyName, bools);
                        this.propertyMap.addAvailableProperty(propertyName);
                        return;
                    }
                    this.propertyMap.put(propertyName, p.getBoolean());
                    this.propertyMap.addAvailableProperty(propertyName);
                    return;
                }
                case 1: {
                    if (propDef.isMultiple()) {
                        Value[] values = p.getValues();
                        String[] strings = new String[values.length];
                        int i = 0;
                        for (Value val : values) {
                            strings[i] = this.stringPool(val.getString());
                            ++i;
                        }
                        this.propertyMap.put(propertyName, strings);
                        this.propertyMap.addAvailableProperty(propertyName);
                        return;
                    }
                    this.propertyMap.put(propertyName, this.stringPool(p.getString()));
                    this.propertyMap.addAvailableProperty(propertyName);
                    return;
                }
                case 3: {
                    if (propDef.isMultiple()) {
                        Value[] values = p.getValues();
                        Long[] longs = new Long[values.length];
                        int i = 0;
                        for (Value val : values) {
                            longs[i] = val.getLong();
                            ++i;
                        }
                        this.propertyMap.put(propertyName, longs);
                        this.propertyMap.addAvailableProperty(propertyName);
                        return;
                    }
                    this.propertyMap.put(propertyName, p.getLong());
                    this.propertyMap.addAvailableProperty(propertyName);
                    return;
                }
                case 4: {
                    if (propDef.isMultiple()) {
                        Value[] values = p.getValues();
                        Double[] doubles = new Double[values.length];
                        int i = 0;
                        for (Value val : values) {
                            doubles[i] = val.getDouble();
                            ++i;
                        }
                        this.propertyMap.put(propertyName, doubles);
                        this.propertyMap.addAvailableProperty(propertyName);
                        return;
                    }
                    this.propertyMap.put(propertyName, p.getDouble());
                    this.propertyMap.addAvailableProperty(propertyName);
                    return;
                }
                case 5: {
                    if (propDef.isMultiple()) {
                        Value[] values = p.getValues();
                        Calendar[] dates = new Calendar[values.length];
                        int i = 0;
                        for (Value val : values) {
                            dates[i] = val.getDate();
                            ++i;
                        }
                        this.propertyMap.put(propertyName, dates);
                        this.propertyMap.addAvailableProperty(propertyName);
                        return;
                    }
                    this.propertyMap.put(propertyName, p.getDate());
                    this.propertyMap.addAvailableProperty(propertyName);
                    return;
                }
            }
            if (log.isWarnEnabled()) {
                log.warn("getPropObject is only support for boolean, long, double, date and strings. Return null");
            }
            return;
        }
        catch (ValueFormatException e) {
            log.warn("ValueFormatException: Exception for fetching property from '{}'", (Object)this.nodePath);
        }
        catch (IllegalStateException e) {
            log.warn("IllegalStateException: Exception for fetching property from '{}'", (Object)this.nodePath);
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e);
        }
    }

    public void flush() {
        this.propertyMap.flush();
    }

    private void populate() {
        if (this.isDetached()) {
            log.warn("Jcr Node is detatched. Return already loaded properties ");
            return;
        }
        try {
            PropertyIterator allProps = this.jcrNode.getProperties();
            while (allProps.hasNext()) {
                Property p = allProps.nextProperty();
                if (this.propertyMap.hasProperty(p.getName()) || 1 != p.getType() && 6 != p.getType() && 5 != p.getType() && 4 != p.getType() && 3 != p.getType()) continue;
                this.loadProperty(p, p.getDefinition(), p.getName());
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e);
        }
        this.isLoaded = true;
    }

    private void populateCanonicalPath() {
        if (this.isDetached()) {
            log.warn("Jcr Node is detatched. Cannot get canonical path");
            return;
        }
        this.canonicalPath = this.nodePath;
        if (this.jcrNode instanceof HippoNode) {
            try {
                Node canonical = ((HippoNode)this.jcrNode).getCanonicalNode();
                if (canonical != null) {
                    this.canonicalPath = canonical.getPath();
                } else {
                    log.info("The canonical path of a virtual only node is the path of the virtual node");
                    this.canonicalPath = this.jcrNode.getPath();
                }
            }
            catch (RepositoryException e) {
                throw new RuntimeRepositoryException(e);
            }
        }
    }

    private void populateIdentifier() {
        if (this.isDetached()) {
            log.warn("Jcr Node is detatched. Cannot get identifier");
            return;
        }
        if (this.jcrNode instanceof HippoNode) {
            try {
                Node canonical = ((HippoNode)this.jcrNode).getCanonicalNode();
                if (canonical != null) {
                    this.identifier = canonical.getIdentifier();
                } else {
                    log.debug("Node '{}' is virtual only. Using virtual path as identifier", (Object)this.jcrNode.getPath());
                    this.identifier = this.jcrNode.getPath();
                }
            }
            catch (RepositoryException e) {
                throw new RuntimeRepositoryException(e);
            }
        }
    }

    private String stringPool(String string) {
        return this.useStringPool ? StringPool.get((String)string) : string;
    }
}

