/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.content.beans.standard.facetnavigation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.RepositoryException;
import org.hippoecm.hst.content.beans.Node;
import org.hippoecm.hst.content.beans.standard.HippoBean;
import org.hippoecm.hst.content.beans.standard.facetnavigation.AbstractHippoFacetChildNavigation;
import org.hippoecm.hst.util.KeyValue;
import org.hippoecm.repository.api.NodeNameCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Node(jcrType="hippofacnav:facetsubnavigation")
public class HippoFacetSubNavigation
extends AbstractHippoFacetChildNavigation {
    private static Logger log = LoggerFactory.getLogger(HippoFacetSubNavigation.class);

    @Override
    public String getName() {
        return NodeNameCodec.decode((String)super.getName());
    }

    @Override
    public boolean isLeaf() {
        if (this.getValueProvider().hasProperty("hippofacnav:leaf")) {
            return (Boolean)this.getProperty("hippofacnav:leaf");
        }
        return false;
    }

    public KeyValue<String, String> getFacetValueCombi() {
        try {
            final String key = this.getNode().getParent().getName();
            final String value = this.getNode().getName();
            return new KeyValue<String, String>(){

                public String getKey() {
                    return key;
                }

                public String getValue() {
                    return value;
                }
            };
        }
        catch (RepositoryException e) {
            log.error("Node must have a parent here. ", (Throwable)e);
            return null;
        }
    }

    public List<HippoFacetSubNavigation> getAncestorsAndSelf() {
        List<HippoFacetSubNavigation> ancestorListAndSelf = this.getAncestors();
        ancestorListAndSelf.add(this);
        return ancestorListAndSelf;
    }

    public List<HippoFacetSubNavigation> getAncestors() {
        HippoFacetSubNavigation grandFatherBean = this.getGrandFatherBean(this);
        ArrayList<HippoFacetSubNavigation> ancestorList = new ArrayList<HippoFacetSubNavigation>();
        if (grandFatherBean != null) {
            ancestorList.add(grandFatherBean);
            while ((grandFatherBean = this.getGrandFatherBean(grandFatherBean)) != null) {
                ancestorList.add(grandFatherBean);
            }
        }
        Collections.reverse(ancestorList);
        return ancestorList;
    }

    private HippoFacetSubNavigation getGrandFatherBean(HippoFacetSubNavigation current) {
        HippoBean grandFatherBean;
        HippoBean parentBean = current.getParentBean();
        if (parentBean != null && (grandFatherBean = parentBean.getParentBean()) != null && grandFatherBean instanceof HippoFacetSubNavigation) {
            return (HippoFacetSubNavigation)grandFatherBean;
        }
        return null;
    }
}

