/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.content.beans.standard.facetnavigation;

import java.util.ArrayList;
import java.util.List;
import org.hippoecm.hst.content.beans.Node;
import org.hippoecm.hst.content.beans.index.Indexable;
import org.hippoecm.hst.content.beans.standard.HippoDocumentBean;
import org.hippoecm.hst.content.beans.standard.HippoFacetChildNavigationBean;
import org.hippoecm.hst.content.beans.standard.HippoFacetNavigationBean;
import org.hippoecm.hst.content.beans.standard.HippoFolder;
import org.hippoecm.hst.content.beans.standard.HippoFolderBean;
import org.hippoecm.hst.content.beans.standard.HippoResultSetBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Indexable(ignore=true)
@Node(jcrType="hippofacnav:facetnavigation")
public class HippoFacetNavigation
extends HippoFolder
implements HippoFacetNavigationBean {
    private static Logger log = LoggerFactory.getLogger(HippoFacetNavigation.class);

    @Override
    public List<HippoFolderBean> getFolders(boolean sorted) {
        List<HippoFolderBean> folders = super.getFolders(sorted);
        ArrayList<HippoFolderBean> remove = new ArrayList<HippoFolderBean>();
        for (HippoFolderBean folder : folders) {
            if (!(folder instanceof HippoResultSetBean)) continue;
            remove.add(folder);
        }
        this.hippoFolders.removeAll(remove);
        return this.hippoFolders;
    }

    public Long getChildCountsCombined() {
        List<HippoFolderBean> folders = this.getFolders(false);
        Long combinedCount = 0L;
        for (HippoFolderBean folder : folders) {
            combinedCount = combinedCount + folder.getValueProvider().getLong("hippo:count");
        }
        return combinedCount;
    }

    @Override
    public List<HippoDocumentBean> getDocuments(boolean sorted) {
        return new ArrayList<HippoDocumentBean>();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public Long getCount() {
        return (Long)this.getProperty("hippo:count");
    }

    public HippoResultSetBean getResultSet() {
        return (HippoResultSetBean)this.getBean("hippo:resultset");
    }

    public HippoFacetNavigationBean getRootFacetNavigationBean() {
        for (HippoFacetNavigation bean = this; bean != null; bean = bean.getParentBean()) {
            if (!(bean instanceof HippoFacetNavigationBean) || bean instanceof HippoFacetChildNavigationBean) continue;
            return bean;
        }
        log.warn("Unable to return the HippoFacetNavigationBean for the current HippoFacetChildNavigationBean at '{}'. Return null", (Object)this.getPath());
        return null;
    }
}

