/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.content.beans.standard;

import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import org.hippoecm.hst.content.beans.Node;
import org.hippoecm.hst.content.beans.standard.HippoItem;
import org.hippoecm.hst.content.beans.standard.HippoResourceBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Node(jcrType="hippo:resource")
public class HippoResource
extends HippoItem
implements HippoResourceBean {
    private static Logger log = LoggerFactory.getLogger(HippoResource.class);
    private static final BigDecimal DIVISOR_K_BYTE = new BigDecimal(8192);
    private static final BigDecimal DIVISOR_M_BYTE = new BigDecimal(0x800000);

    public String getMimeType() {
        return (String)this.getProperty("jcr:mimeType");
    }

    public String getFilename() {
        return (String)this.getProperty("hippo:filename");
    }

    public BigDecimal getLengthKB() {
        return this.calculate(this.getLength() * 8L, DIVISOR_K_BYTE);
    }

    public BigDecimal getLengthMB() {
        return this.calculate(this.getLength() * 8L, DIVISOR_M_BYTE);
    }

    private BigDecimal calculate(long size, BigDecimal divisor) {
        if (size == 0L) {
            return new BigDecimal(0);
        }
        return new BigDecimal(size).divide(divisor);
    }

    public long getLength() {
        if (this.getNode() == null) {
            log.warn("Cannot get length for detached node");
            return 0L;
        }
        try {
            return this.getNode().getProperty("jcr:data").getLength();
        }
        catch (RepositoryException e) {
            log.warn("Error while fetching binary data length.", (Throwable)e);
            return 0L;
        }
    }

    public Calendar getLastModified() {
        try {
            return this.getNode().getProperty("jcr:lastModified").getDate();
        }
        catch (RepositoryException e) {
            log.error("Error during fetching mandatory property jcr:lastModified from '{}'. Return null", (Object)this.getValueProvider().getPath());
            return null;
        }
    }
}

