/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.content.beans.standard;

import javax.jcr.RepositoryException;
import org.hippoecm.hst.content.beans.Node;
import org.hippoecm.hst.content.beans.ObjectBeanManagerException;
import org.hippoecm.hst.content.beans.index.Indexable;
import org.hippoecm.hst.content.beans.standard.BeanWrapper;
import org.hippoecm.hst.content.beans.standard.HippoBean;
import org.hippoecm.hst.content.beans.standard.HippoFolder;
import org.hippoecm.hst.content.beans.standard.HippoMirrorBean;
import org.hippoecm.hst.util.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Indexable(ignore=true)
@Node(jcrType="hippo:mirror")
public class HippoMirror
extends HippoFolder
implements HippoMirrorBean {
    private static Logger log = LoggerFactory.getLogger(HippoMirror.class);
    private BeanWrapper<HippoBean> referencedWrapper;
    private BeanWrapper<HippoBean> derefWrapper;

    public HippoBean getReferencedBean() {
        if (this.referencedWrapper != null) {
            return this.referencedWrapper.getBean();
        }
        if (this.getNode() == null) {
            log.warn("Can not dereference this HippoMirror because it is detached. Return null");
            this.referencedWrapper = new BeanWrapper<Object>(null);
            return null;
        }
        javax.jcr.Node deref = NodeUtils.getDeref((javax.jcr.Node)this.getNode());
        if (deref == null) {
            this.referencedWrapper = new BeanWrapper<Object>(null);
            return null;
        }
        try {
            if (deref.isNodeType("hippo:handle")) {
                if (this.getNode().hasNode(deref.getName())) {
                    javax.jcr.Node linked = this.getNode().getNode(deref.getName());
                    this.referencedWrapper = new BeanWrapper<HippoBean>((HippoBean)this.objectConverter.getObject(linked));
                    return this.referencedWrapper.getBean();
                }
                this.referencedWrapper = new BeanWrapper<Object>(null);
                return null;
            }
            this.referencedWrapper = new BeanWrapper<HippoMirror>(this);
            return this;
        }
        catch (RepositoryException e) {
            log.warn("Cannot get a derefenced HippoBean: {}. Return null", (Throwable)e);
        }
        catch (ObjectBeanManagerException e) {
            log.warn("Cannot get a derefenced HippoBean: {}. Return null", (Object)e.toString());
        }
        this.referencedWrapper = new BeanWrapper<Object>(null);
        return null;
    }

    public HippoBean getDeref() {
        if (this.derefWrapper != null) {
            return this.derefWrapper.getBean();
        }
        if (this.getNode() == null) {
            log.warn("Can not dereference this HippoMirror because it is detached. Return null");
            this.derefWrapper = new BeanWrapper<Object>(null);
            return null;
        }
        javax.jcr.Node deref = NodeUtils.getDeref((javax.jcr.Node)this.getNode());
        if (deref == null) {
            log.warn("Can not dereference this HippoMirror ('{}') because cannot find the node the mirror is pointing to. Return null", (Object)this.getPath());
            this.derefWrapper = new BeanWrapper<Object>(null);
            return null;
        }
        try {
            this.derefWrapper = new BeanWrapper<HippoBean>((HippoBean)this.objectConverter.getObject(deref));
            return this.derefWrapper.getBean();
        }
        catch (ObjectBeanManagerException e) {
            log.warn("Cannot get a derefenced HippoBean: {}. Return null", (Object)e.toString());
            this.derefWrapper = new BeanWrapper<Object>(null);
            return null;
        }
    }
}

