/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.content.beans.standard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.hippoecm.hst.content.beans.ObjectBeanManagerException;
import org.hippoecm.hst.content.beans.index.IndexField;
import org.hippoecm.hst.content.beans.manager.ObjectConverter;
import org.hippoecm.hst.content.beans.standard.AvailableTranslations;
import org.hippoecm.hst.content.beans.standard.HippoAvailableTranslationsBean;
import org.hippoecm.hst.content.beans.standard.HippoBean;
import org.hippoecm.hst.content.beans.standard.HippoDocumentBean;
import org.hippoecm.hst.content.beans.standard.HippoFolderBean;
import org.hippoecm.hst.content.beans.standard.HippoMirrorBean;
import org.hippoecm.hst.provider.jcr.JCRValueProvider;
import org.hippoecm.hst.provider.jcr.JCRValueProviderImpl;
import org.hippoecm.hst.util.NOOPELMap;
import org.hippoecm.repository.api.HippoNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HippoItem
implements HippoBean {
    private static Logger log = LoggerFactory.getLogger(HippoItem.class);
    protected transient Node node;
    protected String comparePath;
    protected String path;
    protected String name;
    protected String localizedName;
    protected JCRValueProvider valueProvider;
    protected transient ObjectConverter objectConverter;
    protected boolean detached = false;
    private String canonicalUUID;
    @Deprecated
    private boolean availableTranslationsBeanInitialized;
    @Deprecated
    private HippoAvailableTranslationsBean availableTranslationsBean;
    private boolean availableTranslationsInitialized;
    private HippoAvailableTranslationsBean availableTranslations;

    public void setObjectConverter(ObjectConverter objectConverter) {
        this.objectConverter = objectConverter;
    }

    public ObjectConverter getObjectConverter() {
        return this.objectConverter;
    }

    public void setNode(Node node) {
        this.node = node;
        this.valueProvider = new JCRValueProviderImpl(node);
    }

    public Node getNode() {
        return this.node;
    }

    public JCRValueProvider getValueProvider() {
        return this.valueProvider;
    }

    public String getIdentifier() {
        return this.getCanonicalUUID();
    }

    public void setIdentifier(String identifier) {
        this.canonicalUUID = identifier;
    }

    @IndexField(ignoreInCompound=true)
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.valueProvider != null) {
            this.name = this.valueProvider.getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @IndexField(ignoreInCompound=true)
    public String getLocalizedName() {
        if (this.localizedName != null) {
            return this.localizedName;
        }
        if (this.valueProvider != null) {
            this.localizedName = this.valueProvider.getLocalizedName();
        }
        return this.localizedName;
    }

    public void setLocalizedName(String localizedName) {
        this.localizedName = localizedName;
    }

    public String getPath() {
        if (this.path != null) {
            return this.path;
        }
        if (this.valueProvider != null) {
            this.path = this.valueProvider.getPath();
        }
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @IndexField(ignoreInCompound=true)
    public String getComparePath() {
        if (this.comparePath != null) {
            return this.comparePath;
        }
        HippoNode node = (HippoNode)this.getNode();
        if (node == null) {
            throw new IllegalStateException("Cannot get comparePath if jcr node is null");
        }
        Node canonical = null;
        try {
            canonical = node.getCanonicalNode();
            this.comparePath = canonical == null ? node.getPath() : canonical.getPath();
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Cannot get comparePath", e);
        }
        return this.comparePath;
    }

    public void setComparePath(String comparePath) {
        this.comparePath = comparePath;
    }

    public String getCanonicalUUID() {
        if (this.canonicalUUID != null) {
            return this.canonicalUUID;
        }
        if (this.getValueProvider() == null) {
            log.warn("Cannot get canonicalUUID for '{}' because no value provider. Return null", (Object)this.getPath());
            return null;
        }
        return this.getValueProvider().getIdentifier();
    }

    public String getCanonicalPath() {
        return this.getValueProvider().getCanonicalPath();
    }

    public Map<String, Object> getProperties() {
        Map properties = null;
        properties = this.valueProvider == null ? Collections.emptyMap() : this.valueProvider.getProperties();
        return properties;
    }

    public <T> T getProperty(String name) {
        return (T)this.getProperties().get(name);
    }

    public <T> T getProperty(String name, T defaultValue) {
        Object val = this.getProperties().get(name);
        if (val == null) {
            return defaultValue;
        }
        return (T)val;
    }

    public Map<String, Object> getProperty() {
        return this.getProperties();
    }

    public <T> T getBean(String relPath) {
        try {
            Object o = this.objectConverter.getObject(this.node, relPath);
            if (o == null) {
                log.debug("Cannot get bean for relpath {} for current bean {}.", (Object)relPath, (Object)this.getPath());
                return null;
            }
            return (T)o;
        }
        catch (ObjectBeanManagerException e) {
            log.warn("Cannot get Object at relPath '{}' for '{}'", (Object)relPath, (Object)this.getPath());
            return null;
        }
    }

    public <T extends HippoBean> T getBean(String relPath, Class<T> beanMappingClass) {
        try {
            Object o = this.objectConverter.getObject(this.node, relPath);
            if (o == null) {
                log.debug("Cannot get bean for relpath {} for current bean {}.", (Object)relPath, (Object)this.getPath());
                return null;
            }
            if (!beanMappingClass.isAssignableFrom(o.getClass())) {
                log.debug("Expected bean of type '{}' but found of type '{}'. Return null.", (Object)beanMappingClass.getName(), (Object)o.getClass().getName());
                return null;
            }
            return (T)((HippoBean)o);
        }
        catch (ObjectBeanManagerException e) {
            log.warn("Cannot get Object at relPath '{}' for '{}'", (Object)relPath, (Object)this.getPath());
            return null;
        }
    }

    public <T extends HippoBean> List<T> getChildBeans(Class<T> beanMappingClass) {
        ArrayList<HippoBean> childBeans = new ArrayList<HippoBean>();
        try {
            NodeIterator nodes = this.node.getNodes();
            while (nodes.hasNext()) {
                Node child = nodes.nextNode();
                if (child == null) continue;
                try {
                    Object bean = this.objectConverter.getObject(child);
                    if (bean == null) continue;
                    if (beanMappingClass != null) {
                        if (beanMappingClass.isAssignableFrom(bean.getClass())) {
                            childBeans.add((HippoBean)bean);
                            continue;
                        }
                        log.debug("Skipping bean of type '{}' because not of beanMappingClass '{}'", (Object)bean.getClass().getName(), (Object)beanMappingClass.getName());
                        continue;
                    }
                    childBeans.add((HippoBean)bean);
                }
                catch (ObjectBeanManagerException e) {
                    log.warn("Skipping bean: {}", (Throwable)e);
                }
            }
        }
        catch (RepositoryException e) {
            log.error("RepositoryException: Error while trying to create childBeans:", (Throwable)e);
            return new ArrayList();
        }
        return childBeans;
    }

    public <T> List<T> getChildBeansByName(String childNodeName) {
        return this.getChildBeansByName(childNodeName, null);
    }

    public <T extends HippoBean> List<T> getChildBeansByName(String childNodeName, Class<T> beanMappingClass) {
        ArrayList<HippoBean> childBeans = new ArrayList<HippoBean>();
        try {
            NodeIterator nodes = this.node.getNodes();
            while (nodes.hasNext()) {
                Node child = nodes.nextNode();
                if (child == null || !child.getName().equals(childNodeName)) continue;
                try {
                    Object bean = this.objectConverter.getObject(child);
                    if (bean == null) continue;
                    if (beanMappingClass != null) {
                        if (beanMappingClass.isAssignableFrom(bean.getClass())) {
                            childBeans.add((HippoBean)bean);
                            continue;
                        }
                        log.debug("Skipping bean of type '{}' because not of beanMappingClass '{}'", (Object)bean.getClass().getName(), (Object)beanMappingClass.getName());
                        continue;
                    }
                    childBeans.add((HippoBean)bean);
                }
                catch (ObjectBeanManagerException e) {
                    log.warn("Skipping bean: {}", (Throwable)e);
                }
            }
        }
        catch (RepositoryException e) {
            log.error("RepositoryException: Error while trying to create childBeans:", (Throwable)e);
            return new ArrayList();
        }
        return childBeans;
    }

    public <T> List<T> getChildBeans(String jcrPrimaryNodeType) {
        Class annotatedClass = this.objectConverter.getAnnotatedClassFor(jcrPrimaryNodeType);
        if (annotatedClass == null) {
            log.warn("Cannot get ChildBeans for jcrPrimaryNodeType '{}' because there is no annotated class for this node type. Return null", (Object)jcrPrimaryNodeType);
            return new ArrayList();
        }
        if (this.node == null) {
            log.warn("Cannot get ChildBeans for jcrPrimaryNodeType '{}' because the jcr node is detached. ", (Object)jcrPrimaryNodeType);
            return new ArrayList();
        }
        ArrayList<Object> childBeans = new ArrayList<Object>();
        try {
            NodeIterator nodes = this.node.getNodes();
            while (nodes.hasNext()) {
                Node child = nodes.nextNode();
                if (child == null) continue;
                try {
                    Object bean;
                    String nodeObjectType = this.objectConverter.getPrimaryObjectType(child);
                    if (nodeObjectType == null || !nodeObjectType.equals(jcrPrimaryNodeType) || (bean = this.objectConverter.getObject(child)) == null) continue;
                    childBeans.add(bean);
                }
                catch (ObjectBeanManagerException e) {
                    log.warn("Skipping bean: {}", (Throwable)e);
                }
            }
        }
        catch (RepositoryException e) {
            log.error("RepositoryException: Cannot get ChildBeans for jcrPrimaryNodeType: '" + jcrPrimaryNodeType + "' ", (Throwable)e);
            return new ArrayList();
        }
        return childBeans;
    }

    public <T extends HippoBean> T getLinkedBean(String relPath, Class<T> beanMappingClass) {
        HippoMirrorBean mirror = this.getBean(relPath, HippoMirrorBean.class);
        if (mirror == null) {
            return null;
        }
        HippoBean bean = mirror.getReferencedBean();
        if (bean == null) {
            return null;
        }
        if (!beanMappingClass.isAssignableFrom(bean.getClass())) {
            log.debug("Expected bean of type '{}' but found of type '{}'. Return null.", (Object)beanMappingClass.getName(), (Object)bean.getClass().getName());
            return null;
        }
        return (T)bean;
    }

    public <T extends HippoBean> List<T> getLinkedBeans(String relPath, Class<T> beanMappingClass) {
        ArrayList<HippoBean> childBeans = new ArrayList<HippoBean>();
        String fromNode = null;
        String nodeName = relPath;
        if (relPath.contains("/")) {
            fromNode = relPath.substring(0, relPath.lastIndexOf("/"));
            nodeName = relPath.substring(relPath.lastIndexOf("/") + 1);
        }
        Node relNode = this.node;
        if (fromNode != null) {
            try {
                relNode = relNode.getNode(fromNode);
            }
            catch (PathNotFoundException e) {
                log.debug("did not find relPath '{}' at '{}'. Return empty list", (Object)relPath, (Object)this.getPath());
                return childBeans;
            }
            catch (RepositoryException e) {
                log.warn("RepositoryException", (Throwable)e);
                return childBeans;
            }
        }
        try {
            NodeIterator nodes = relNode.getNodes();
            while (nodes.hasNext()) {
                Node child = nodes.nextNode();
                if (child == null) continue;
                try {
                    HippoBean linked;
                    Object bean = this.objectConverter.getObject(child);
                    if (!child.getName().equals(nodeName) || !(bean instanceof HippoMirrorBean) || (linked = ((HippoMirrorBean)bean).getReferencedBean()) == null || !beanMappingClass.isAssignableFrom(linked.getClass())) continue;
                    childBeans.add(linked);
                }
                catch (ObjectBeanManagerException e) {
                    if (log.isDebugEnabled()) {
                        log.warn("Could not map jcr node to bean: '{}'", (Throwable)e);
                        continue;
                    }
                    log.warn("Could not map jcr node to bean: '{}'", (Object)e.getMessage());
                }
            }
        }
        catch (PathNotFoundException e) {
            log.debug("did not find relPath '{}' at '{}'. Return empty list", (Object)relPath, (Object)this.getPath());
        }
        catch (RepositoryException e) {
            log.warn("RepositoryException", (Throwable)e);
        }
        return childBeans;
    }

    public HippoBean getParentBean() {
        try {
            Object o;
            Node parentNode = this.valueProvider.getParentJcrNode();
            if (parentNode == null) {
                log.warn("Cannot get parent bean for detached bean");
                return null;
            }
            if (parentNode.isNodeType("hippo:handle")) {
                parentNode = parentNode.getParent();
            }
            if ((o = this.objectConverter.getObject(parentNode)) == null) {
                log.debug("Failed to get parent bean for node '{}'", (Object)parentNode.getPath());
                return null;
            }
            if (o instanceof HippoBean) {
                return (HippoBean)o;
            }
            log.warn("Bean is not an instance of HippoBean. Return null : ", o);
        }
        catch (ObjectBeanManagerException e) {
            log.warn("Failed to get parent object for '{}'", (Object)this.getPath());
        }
        catch (RepositoryException e) {
            log.warn("Failed to get parent object for '{}'", (Object)this.getPath());
        }
        return null;
    }

    public <T extends HippoBean> T getCanonicalBean() {
        if (this.getNode() == null) {
            log.warn("Cannot get canonical bean for detached bean. Return just the current bean instance");
            return (T)this;
        }
        try {
            HippoNode hn = (HippoNode)this.getNode();
            if (!hn.isVirtual()) {
                return (T)this;
            }
            Node canonical = hn.getCanonicalNode();
            if (canonical == null) {
                log.debug("Cannot get canonical for a node that is virtual only: '{}'. Return null", (Object)this.getPath());
                return null;
            }
            Object o = this.objectConverter.getObject(canonical);
            if (o instanceof HippoBean) {
                log.debug("Getting canonical bean succeeded: translated from '{}' --> '{}'", (Object)this.getPath(), (Object)((HippoBean)o).getPath());
                return (T)((HippoBean)o);
            }
            log.warn("Bean is not an instance of HippoBean. Return null : ", o);
        }
        catch (ObjectBeanManagerException e) {
            log.warn("Exception while trying to fetch canonical bean. Return null : {}", (Object)e.toString());
        }
        catch (RepositoryException e) {
            log.warn("Exception while trying to fetch canonical bean. Return null : {}", (Object)e.toString());
        }
        return null;
    }

    public HippoBean getContextualBean() {
        if (this.getNode() == null) {
            log.warn("Cannot get contextual bean for detached bean. Return just the current bean instance");
            return this;
        }
        try {
            Node canonical = ((HippoNode)this.getNode()).getCanonicalNode();
            if (canonical == null) {
                log.debug("Cannot get canonical for a node that is virtual only: '{}'. It's contextual bean is just the current bean", (Object)this.getPath());
                return this;
            }
            Object o = this.objectConverter.getObject(canonical);
            if (o instanceof HippoBean) {
                if (this.equals(o)) {
                    return this;
                }
                log.debug("Contextualisation succeeded: translated from '{}' --> '{}'", (Object)this.getPath(), (Object)((HippoBean)o).getPath());
                return (HippoBean)o;
            }
            log.warn("Bean is not an instance of HippoBean. Return null : ", o);
        }
        catch (ObjectBeanManagerException e) {
            log.warn("HstContextualizeException while trying to fetch contextual bean. Return null : {}", (Object)e.toString());
        }
        catch (RepositoryException e) {
            log.warn("HstContextualizeException while trying to fetch contextual bean. Return null :  {}", (Object)e.toString());
        }
        return null;
    }

    public HippoBean getContextualParentBean() {
        HippoBean contextualBean = this.getContextualBean();
        if (contextualBean == null) {
            log.warn("Cannot return contextual parent bean. Return null");
            return null;
        }
        return contextualBean.getParentBean();
    }

    public boolean isAncestor(HippoBean compare) {
        if (this.getPath() == null || compare.getPath() == null) {
            log.warn("Cannot compare the HippoBeans as one as a path that is null. Return false.");
            return false;
        }
        return compare.getPath().startsWith(this.getPath() + "/");
    }

    public boolean isLeaf() {
        if (this.getNode() == null) {
            return true;
        }
        try {
            return !this.node.hasNodes();
        }
        catch (RepositoryException e) {
            log.error("Repository exception : ", (Throwable)e);
            return true;
        }
    }

    public boolean isDescendant(HippoBean compare) {
        if (this.getPath() == null || compare.getPath() == null) {
            log.warn("Cannot compare the HippoBeans as one as a path that is null. Return false.");
            return false;
        }
        return this.getPath().startsWith(compare.getPath() + "/");
    }

    public boolean isSelf(HippoBean compare) {
        if (this.getPath() == null || compare.getPath() == null) {
            log.warn("Cannot compare the HippoBeans as one as a path that is null. Return false.");
            return false;
        }
        return this.getPath().equals(compare.getPath());
    }

    public boolean isHippoDocumentBean() {
        return this instanceof HippoDocumentBean;
    }

    public boolean isHippoFolderBean() {
        return this instanceof HippoFolderBean;
    }

    public <T extends HippoBean> HippoAvailableTranslationsBean<T> getAvailableTranslationsBean() {
        if (!this.availableTranslationsBeanInitialized) {
            this.availableTranslationsBeanInitialized = true;
            try {
                this.availableTranslationsBean = (HippoAvailableTranslationsBean)this.getBean("hippotranslation:translations");
            }
            catch (ClassCastException e) {
                log.warn("Bean with name 'hippotranslation:translations' was not of type '{}'. Unexpected. Cannot get translation bean", (Object)HippoAvailableTranslationsBean.class.getName());
            }
            if (this.availableTranslationsBean == null) {
                this.availableTranslationsBean = new HippoAvailableTranslationsBean.NoopTranslationsBean();
                log.debug("Did not find a translations bean for '{}'. Return a no-operation instance of it", (Object)this.getValueProvider().getPath());
            }
        }
        return this.availableTranslationsBean;
    }

    public <T extends HippoBean> HippoAvailableTranslationsBean<T> getAvailableTranslations() {
        if (!this.availableTranslationsInitialized) {
            this.availableTranslationsInitialized = true;
            this.availableTranslations = new AvailableTranslations(this.getNode(), this.getObjectConverter());
        }
        return this.availableTranslations;
    }

    public boolean equalCompare(Object compare) {
        return (Boolean)new ComparatorMap().get(compare);
    }

    public Map<Object, Object> getEqualComparator() {
        return new ComparatorMap();
    }

    public int compareTo(HippoBean hippoBean) {
        if (hippoBean == null) {
            throw new NullPointerException("HippoBean to compareTo is not allowed to be null");
        }
        if (this.getName() == null) {
            throw new IllegalStateException("Cannot compare when getName is null");
        }
        if (hippoBean.getName() == null) {
            throw new IllegalStateException("Cannot compare when getName is null");
        }
        int val = this.getName().compareTo(hippoBean.getName());
        if (val != 0) {
            return val;
        }
        if (this.getPath() == null && hippoBean.getPath() == null) {
            return 0;
        }
        if (this.getPath() == null) {
            return 1;
        }
        if (hippoBean.getPath() == null) {
            return -1;
        }
        return this.getPath().compareTo(hippoBean.getPath());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getPath() == null) {
            return false;
        }
        if (obj instanceof HippoBean) {
            return this.getPath().equals(((HippoBean)obj).getPath());
        }
        return false;
    }

    public void detach() {
        this.valueProvider.detach();
        this.node = null;
        this.detached = true;
    }

    public void attach(Session session) {
        if (this.getPath() == null) {
            log.error("Unable to attach HippoBean again since getPath() is null");
            return;
        }
        try {
            if (session.itemExists(this.getPath())) {
                Item item = session.getItem(this.getPath());
                if (item instanceof Node) {
                    this.valueProvider = new JCRValueProviderImpl((Node)item);
                } else {
                    log.warn("Cannot attach an item that is not a jcr property: '{}'", (Object)this.getPath());
                }
            }
        }
        catch (RepositoryException e) {
            log.error("Repository exception while trying to attach jcr node: {}", (Throwable)e);
        }
    }

    public int hashCode() {
        return this.getPath() == null ? super.hashCode() : this.getPath().hashCode();
    }

    public class ComparatorMap
    extends NOOPELMap {
        @Override
        public Object get(Object compare) {
            if (!(compare instanceof HippoItem)) {
                return false;
            }
            HippoItem compareItem = (HippoItem)compare;
            try {
                return compareItem.getComparePath().equals(HippoItem.this.getComparePath());
            }
            catch (IllegalStateException e) {
                log.error("Could not compare items correctly : ", (Throwable)e);
                return false;
            }
        }
    }
}

