/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.content.beans.standard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.LocaleUtils;
import org.hippoecm.hst.content.beans.Node;
import org.hippoecm.hst.content.beans.ObjectBeanManagerException;
import org.hippoecm.hst.content.beans.standard.HippoDocument;
import org.hippoecm.hst.content.beans.standard.HippoDocumentBean;
import org.hippoecm.hst.content.beans.standard.HippoDocumentIterator;
import org.hippoecm.hst.content.beans.standard.HippoFolderBean;
import org.hippoecm.hst.content.beans.standard.HippoItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Node(jcrType="hippostd:folder")
public class HippoFolder
extends HippoItem
implements HippoFolderBean {
    private static Logger log = LoggerFactory.getLogger(HippoFolder.class);
    protected ArrayList<HippoFolderBean> hippoFolders;
    protected ArrayList<HippoDocumentBean> hippoDocuments;

    public String getLocaleString() {
        return (String)this.getProperty("hippotranslation:locale");
    }

    public Locale getLocale() {
        String localeString = this.getLocaleString();
        try {
            return LocaleUtils.toLocale((String)localeString);
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid locale '{}' for document '{}' : {}", new Object[]{localeString, this.getPath(), e.toString()});
            return null;
        }
    }

    public List<HippoFolderBean> getFolders() {
        return this.getFolders(false);
    }

    public List<HippoFolderBean> getFolders(boolean sorted) {
        if (this.hippoFolders != null) {
            if (sorted) {
                ArrayList dest = (ArrayList)this.hippoFolders.clone();
                Collections.sort(dest);
                return dest;
            }
            return this.hippoFolders;
        }
        if (this.node == null) {
            log.warn("Cannot get documents because node is null");
            return new ArrayList<HippoFolderBean>();
        }
        try {
            this.hippoFolders = new ArrayList();
            NodeIterator nodes = this.node.getNodes();
            while (nodes.hasNext()) {
                HippoFolderBean hippoFolder;
                javax.jcr.Node child = nodes.nextNode();
                if (child == null || (hippoFolder = this.getHippoFolder(child)) == null) continue;
                this.hippoFolders.add(hippoFolder);
            }
            if (sorted) {
                ArrayList dest = (ArrayList)this.hippoFolders.clone();
                Collections.sort(dest);
                return dest;
            }
            return this.hippoFolders;
        }
        catch (RepositoryException e) {
            log.warn("Repository Exception : {}", (Throwable)e);
            return new ArrayList<HippoFolderBean>();
        }
    }

    public int getDocumentSize() {
        return this.getDocuments().size();
    }

    public List<HippoDocumentBean> getDocuments() {
        return this.getDocuments(false);
    }

    public List<HippoDocumentBean> getDocuments(int from, int to) {
        return this.getDocuments(from, to, false);
    }

    public List<HippoDocumentBean> getDocuments(int from, int to, boolean sorted) {
        List<HippoDocumentBean> documents = this.getDocuments(sorted);
        try {
            return documents.subList(from, to);
        }
        catch (IndexOutOfBoundsException e) {
            log.warn("Invalid sublist for getDocuments '{}'. Return empty list.", (Object)e.getMessage());
            return new ArrayList<HippoDocumentBean>();
        }
    }

    public <T> List<T> getDocuments(Class<T> beanMappingClass) {
        List<HippoDocumentBean> documents = this.getDocuments();
        ArrayList<HippoDocumentBean> documentOfClass = new ArrayList<HippoDocumentBean>();
        for (HippoDocumentBean bean : documents) {
            if (!beanMappingClass.isAssignableFrom(bean.getClass())) continue;
            documentOfClass.add(bean);
        }
        return documentOfClass;
    }

    public List<HippoDocumentBean> getDocuments(boolean sorted) {
        if (this.hippoDocuments != null) {
            if (sorted) {
                ArrayList dest = (ArrayList)this.hippoDocuments.clone();
                Collections.sort(dest);
                return dest;
            }
            return this.hippoDocuments;
        }
        if (this.node == null) {
            log.warn("Cannot get documents because node is null");
            return new ArrayList<HippoDocumentBean>();
        }
        try {
            this.hippoDocuments = new ArrayList();
            NodeIterator nodes = this.node.getNodes();
            while (nodes.hasNext()) {
                HippoDocumentBean hippoDocument;
                javax.jcr.Node child = nodes.nextNode();
                if (child == null || (hippoDocument = this.getHippoDocument(child)) == null) continue;
                this.hippoDocuments.add(hippoDocument);
            }
            if (sorted) {
                ArrayList dest = (ArrayList)this.hippoDocuments.clone();
                Collections.sort(dest);
                return dest;
            }
            return this.hippoDocuments;
        }
        catch (RepositoryException e) {
            log.warn("Repository Exception : {}", (Throwable)e);
            return new ArrayList<HippoDocumentBean>();
        }
    }

    private HippoFolderBean getHippoFolder(javax.jcr.Node child) {
        try {
            Object o = this.objectConverter.getObject(child);
            if (o instanceof HippoFolderBean) {
                return (HippoFolderBean)o;
            }
        }
        catch (ObjectBeanManagerException e) {
            log.warn("Cannot return HippoFolder. Return null : {} ", (Throwable)e);
        }
        return null;
    }

    private <T> T getHippoDocument(javax.jcr.Node node, Class<T> beanMappingClass) {
        HippoDocumentBean bean = this.getHippoDocument(node);
        if (bean == null) {
            return null;
        }
        if (beanMappingClass.isAssignableFrom(bean.getClass())) {
            return (T)bean;
        }
        return null;
    }

    private HippoDocumentBean getHippoDocument(javax.jcr.Node node) {
        try {
            if (node.isNodeType("hippo:handle")) {
                if (node.hasNode(node.getName())) {
                    Object o = this.objectConverter.getObject(node.getNode(node.getName()));
                    if (o instanceof HippoDocumentBean) {
                        return (HippoDocumentBean)o;
                    }
                    log.warn("Cannot return HippoDocument for  '{}'. Return null", (Object)node.getPath());
                }
                return null;
            }
            if (node.getParent().isNodeType("hippo:handle") || node.getParent().isNodeType("hippo:facetresult")) {
                Object hippoDoc = this.objectConverter.getObject(node);
                if (hippoDoc == null) {
                    log.warn("Cannot return HippoDocument for '{}'. Return null", (Object)node.getPath());
                }
                if (!(hippoDoc instanceof HippoDocument)) {
                    log.info("Cannot bind '{}' to a HippoDocument. Return null.", (Object)node.getPath());
                    return null;
                }
                return (HippoDocument)hippoDoc;
            }
        }
        catch (RepositoryException e) {
            log.error("Cannot return HippoDocument. Return null : {} ", (Throwable)e);
        }
        catch (ObjectBeanManagerException e) {
            log.warn("Cannot return HippoDocument. Return null : {} ", (Throwable)e);
        }
        return null;
    }

    public <T> HippoDocumentIterator<T> getDocumentIterator(Class<T> beanMappingClass) {
        return new HippoDocumentIteratorImpl<T>(beanMappingClass);
    }

    private class HippoDocumentIteratorImpl<T>
    implements HippoDocumentIterator<T> {
        NodeIterator nodeIterator;
        Class<T> beanMappingClass;
        T nextHippoDocument;
        int position = -1;

        public HippoDocumentIteratorImpl(Class<T> beanMappingClass) {
            if (beanMappingClass == null) {
                throw new IllegalArgumentException("beanMappingClass not allowed to be null");
            }
            this.beanMappingClass = beanMappingClass;
            if (HippoFolder.this.node == null) {
                log.warn("Cannot get documents because node is null");
            } else {
                try {
                    this.nodeIterator = HippoFolder.this.node.getNodes();
                }
                catch (RepositoryException e) {
                    log.warn("Repository exception happened. Return empty iterator");
                }
            }
        }

        public void skip(int skipNum) {
            if (this.nodeIterator == null) {
                return;
            }
            if (skipNum < 0) {
                throw new IllegalArgumentException("SkipNum is not allowed to be negative");
            }
            while (skipNum > 0 && this.nodeIterator.hasNext()) {
                Object hippoDocument;
                javax.jcr.Node child = this.nodeIterator.nextNode();
                if (child == null || (hippoDocument = HippoFolder.this.getHippoDocument(child, this.beanMappingClass)) == null) continue;
                ++this.position;
                --skipNum;
            }
            if (skipNum > 0) {
                log.debug("Skipped beyond last hippo document. Iterator won't return any hippo documents anymore");
            }
        }

        public boolean hasNext() {
            if (this.nodeIterator == null) {
                return false;
            }
            if (this.nextHippoDocument != null) {
                return true;
            }
            while (this.nodeIterator.hasNext()) {
                Object hippoDocument;
                javax.jcr.Node child = this.nodeIterator.nextNode();
                if (child == null || (hippoDocument = HippoFolder.this.getHippoDocument(child, this.beanMappingClass)) == null) continue;
                this.nextHippoDocument = hippoDocument;
                return true;
            }
            return false;
        }

        public T next() {
            if (this.nodeIterator == null) {
                throw new NoSuchElementException("NodeIterator is null. No next element");
            }
            if (this.nextHippoDocument != null) {
                T next = this.nextHippoDocument;
                this.nextHippoDocument = null;
                ++this.position;
                return next;
            }
            while (this.nodeIterator.hasNext()) {
                Object hippoDocument;
                javax.jcr.Node child = this.nodeIterator.nextNode();
                if (child == null || (hippoDocument = HippoFolder.this.getHippoDocument(child, this.beanMappingClass)) == null) continue;
                ++this.position;
                return (T)hippoDocument;
            }
            throw new NoSuchElementException("No next HippoDocumentBean");
        }

        public void remove() {
            throw new NoSuchElementException("Remove is not supported");
        }

        public int getPosition() {
            return this.position == -1 ? 0 : this.position;
        }
    }
}

