/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.content.beans.standard;

import java.util.Locale;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.LocaleUtils;
import org.hippoecm.hst.content.beans.Node;
import org.hippoecm.hst.content.beans.standard.AvailableTranslations;
import org.hippoecm.hst.content.beans.standard.BeansWrapper;
import org.hippoecm.hst.content.beans.standard.HippoAvailableTranslations;
import org.hippoecm.hst.content.beans.standard.HippoAvailableTranslationsBean;
import org.hippoecm.hst.content.beans.standard.HippoBean;
import org.hippoecm.hst.content.beans.standard.HippoCompoundBean;
import org.hippoecm.hst.content.beans.standard.HippoDocumentBean;
import org.hippoecm.hst.content.beans.standard.HippoHtml;
import org.hippoecm.hst.content.beans.standard.HippoItem;
import org.hippoecm.repository.api.HippoNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Node(jcrType="hippo:document")
public class HippoDocument
extends HippoItem
implements HippoDocumentBean {
    private static Logger log = LoggerFactory.getLogger(HippoDocument.class);
    private BeansWrapper<HippoHtml> htmls;
    private BeansWrapper<HippoCompoundBean> compounds;
    private javax.jcr.Node canonicalHandleNode;
    @Deprecated
    private boolean availableTranslationsBeanMappingClassInitialized;
    @Deprecated
    private HippoAvailableTranslationsBean availableTranslationsBeanMappingClass;
    private boolean availableTranslationsMappingClassInitialized;
    private HippoAvailableTranslationsBean availableTranslationsMappingClass;

    public HippoHtml getHippoHtml(String relPath) {
        if (this.htmls == null) {
            this.htmls = new BeansWrapper(this);
        }
        return this.htmls.getBean(relPath, HippoHtml.class);
    }

    public <T extends HippoCompoundBean> T getHippoCompound(String relPath, Class<T> beanMappingClass) {
        HippoCompoundBean compound;
        if (this.compounds == null) {
            this.compounds = new BeansWrapper(this);
        }
        if (beanMappingClass.isAssignableFrom((compound = this.compounds.getBean(relPath, HippoCompoundBean.class)).getClass())) {
            return (T)compound;
        }
        log.debug("Cannot return compound of type '" + beanMappingClass.getName() + "' for relPath '{}' at '{}' because the compound is of type '" + compound.getClass().getName() + "'", (Object)relPath, (Object)this.getPath());
        return null;
    }

    public String getCanonicalHandleUUID() {
        try {
            return this.getCanonicalHandleNode() == null ? null : this.getCanonicalHandleNode().getIdentifier();
        }
        catch (RepositoryException e) {
            log.error("Cannot get handle uuid for node '" + this.getPath() + "'. Return null", (Throwable)e);
            return null;
        }
    }

    public String getCanonicalHandlePath() {
        try {
            return this.getCanonicalHandleNode() == null ? null : this.getCanonicalHandleNode().getPath();
        }
        catch (RepositoryException e) {
            log.error("Cannot get handle path for node '" + this.getPath() + "'. Return null", (Throwable)e);
            return null;
        }
    }

    private javax.jcr.Node getCanonicalHandleNode() {
        if (this.canonicalHandleNode != null) {
            return this.canonicalHandleNode;
        }
        if (this.getNode() == null) {
            log.warn("Cannot get handle uuid for detached node '{}'", (Object)this.getPath());
            return null;
        }
        try {
            javax.jcr.Node canonical = ((HippoNode)this.getNode()).getCanonicalNode();
            if (canonical == null) {
                log.error("We cannot get the canonical handle uuid for a document that does not have a canonical version. Node '{}'. Return null", (Object)this.getNode().getPath());
                return null;
            }
            this.canonicalHandleNode = canonical.getParent();
        }
        catch (RepositoryException e) {
            log.error("Cannot get handle uuid for node '" + this.getPath() + "'", (Throwable)e);
        }
        return this.canonicalHandleNode;
    }

    public String getLocaleString() {
        return (String)this.getProperty("hippotranslation:locale");
    }

    public Locale getLocale() {
        String localeString = this.getLocaleString();
        try {
            return LocaleUtils.toLocale((String)localeString);
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid locale '{}' for document '{}' : {}", new Object[]{localeString, this.getPath(), e.toString()});
            return null;
        }
    }

    public <T extends HippoBean> HippoAvailableTranslationsBean<T> getAvailableTranslationsBean(Class<T> beanMappingClass) {
        if (!this.availableTranslationsBeanMappingClassInitialized) {
            this.availableTranslationsBeanMappingClassInitialized = true;
            try {
                this.availableTranslationsBeanMappingClass = (HippoAvailableTranslationsBean)this.getBean("hippotranslation:translations");
            }
            catch (ClassCastException e) {
                log.warn("Bean with name 'hippotranslation:translations' was not of type '{}'. Unexpected. Cannot get translation bean", (Object)HippoAvailableTranslationsBean.class.getName());
            }
            if (this.availableTranslationsBeanMappingClass == null) {
                this.availableTranslationsBeanMappingClass = new HippoAvailableTranslationsBean.NoopTranslationsBean();
                log.debug("Did not find a translations bean for '{}'. Return a no-operation instance of it", (Object)this.getValueProvider().getPath());
            } else {
                ((HippoAvailableTranslations)this.availableTranslationsBeanMappingClass).setBeanMappingClass(beanMappingClass);
            }
        }
        return this.availableTranslationsBeanMappingClass;
    }

    public <T extends HippoBean> HippoAvailableTranslationsBean<T> getAvailableTranslations(Class<T> beanMappingClass) {
        if (!this.availableTranslationsMappingClassInitialized) {
            this.availableTranslationsMappingClassInitialized = true;
            this.availableTranslationsMappingClass = new AvailableTranslations(this.getNode(), this.getObjectConverter());
            ((AvailableTranslations)this.availableTranslationsMappingClass).setBeanMappingClass(beanMappingClass);
        }
        return this.availableTranslationsMappingClass;
    }

    @Override
    public void detach() {
        super.detach();
        this.htmls.detach();
    }

    @Override
    public void attach(Session session) {
        super.attach(session);
        this.htmls = null;
    }
}

