/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.content.beans.standard;

import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.hippoecm.hst.content.beans.ObjectBeanManagerException;
import org.hippoecm.hst.content.beans.manager.ObjectConverter;
import org.hippoecm.hst.content.beans.standard.HippoBean;
import org.hippoecm.hst.content.beans.standard.HippoBeanIterator;
import org.hippoecm.hst.diagnosis.HDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HippoBeanIteratorImpl
implements HippoBeanIterator {
    private static final Logger log = LoggerFactory.getLogger(HippoBeanIteratorImpl.class);
    private ObjectConverter objectConverter;
    private NodeIterator nodeIterator;

    public HippoBeanIteratorImpl(ObjectConverter objectConverter, NodeIterator nodeIterator) {
        this.objectConverter = objectConverter;
        this.nodeIterator = nodeIterator;
    }

    public long getPosition() {
        return this.nodeIterator.getPosition();
    }

    public long getSize() {
        return this.nodeIterator.getSize();
    }

    public HippoBean nextHippoBean() {
        Node n = null;
        try {
            n = this.nodeIterator.nextNode();
            if (n != null) {
                if (HDC.isStarted()) {
                    AtomicInteger iterCount = (AtomicInteger)HDC.getCurrentTask().getAttribute("HippoBeanIterationCount");
                    if (iterCount == null) {
                        HDC.getCurrentTask().setAttribute("HippoBeanIterationCount", (Object)new AtomicInteger(1));
                    } else {
                        iterCount.incrementAndGet();
                    }
                }
                return (HippoBean)this.objectConverter.getObject(n);
            }
            log.warn("Node in node iterator is null. Cannot return a HippoStdNode");
        }
        catch (ObjectBeanManagerException e) {
            String path = this.getPath(n);
            log.warn("ObjectContentManagerException. Return null for '" + path + "'", (Throwable)e);
        }
        return null;
    }

    private String getPath(Node n) {
        if (n == null) {
            return "";
        }
        try {
            return n.getPath();
        }
        catch (RepositoryException e) {
            log.error("RepositoryException ", (Throwable)e);
            return "";
        }
    }

    public void skip(int skipNum) {
        this.nodeIterator.skip((long)skipNum);
    }

    public boolean hasNext() {
        return this.nodeIterator.hasNext();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public HippoBean next() {
        return this.nextHippoBean();
    }
}

