/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.content.beans.standard;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.hippoecm.hst.content.beans.Node;
import org.hippoecm.hst.content.beans.ObjectBeanManagerException;
import org.hippoecm.hst.content.beans.index.Indexable;
import org.hippoecm.hst.content.beans.standard.HippoAvailableTranslationsBean;
import org.hippoecm.hst.content.beans.standard.HippoBean;
import org.hippoecm.hst.content.beans.standard.HippoItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Indexable(ignore=true)
@Node(jcrType="hippotranslation:translations")
public class HippoAvailableTranslations<K extends HippoBean>
extends HippoItem
implements HippoAvailableTranslationsBean<K> {
    private static final Logger log = LoggerFactory.getLogger(HippoAvailableTranslations.class);
    private Map<String, K> translations;
    private Class<K> beanMappingClass;

    public List<String> getAvailableLocales() {
        this.populate();
        return new ArrayList<String>(this.translations.keySet());
    }

    public K getTranslation(String locale) {
        this.populate();
        return (K)((HippoBean)this.translations.get(locale));
    }

    public List<K> getTranslations() {
        this.populate();
        return new ArrayList<K>(this.translations.values());
    }

    public boolean hasTranslation(String locale) {
        this.populate();
        return this.translations.get(locale) != null;
    }

    private void populate() {
        if (this.translations != null) {
            return;
        }
        if (this.getNode() == null) {
            log.debug("Cannot get translations for detached bean.");
            return;
        }
        try {
            this.populateTranslations(this.getNode());
        }
        catch (RepositoryException e) {
            log.warn("Exception while trying to fetch translations.", (Throwable)e);
        }
    }

    public void setBeanMappingClass(Class<K> beanMappingClass) {
        this.beanMappingClass = beanMappingClass;
    }

    private void populateTranslations(javax.jcr.Node translationNode) throws RepositoryException {
        javax.jcr.Node docNode = translationNode.getParent();
        this.translations = new LinkedHashMap<String, K>();
        if (!docNode.hasProperty("hippotranslation:id")) {
            log.debug("No translations for '{}' since property '{}' not available", (Object)docNode.getPath(), (Object)"hippotranslation:id");
            return;
        }
        String id = docNode.getProperty("hippotranslation:id").getString();
        String xpath = "//element(*,hippotranslation:translated)[hippotranslation:id = '" + id + "']";
        Query query = docNode.getSession().getWorkspace().getQueryManager().createQuery(xpath, "xpath");
        QueryResult result = query.execute();
        NodeIterator nodeIterator = result.getNodes();
        while (nodeIterator.hasNext()) {
            javax.jcr.Node translation = nodeIterator.nextNode();
            if (translation == null) continue;
            if (!translation.hasProperty("hippotranslation:locale")) {
                log.debug("Skipping node '{}' because does not contain property '{}'", (Object)translation.getPath(), (Object)"hippotranslation:locale");
                continue;
            }
            String locale = translation.getProperty("hippotranslation:locale").getString();
            try {
                Object bean = this.objectConverter.getObject(translation);
                if (bean == null) continue;
                if (this.beanMappingClass != null) {
                    if (this.beanMappingClass.isAssignableFrom(bean.getClass())) {
                        this.translations.put(locale, (String)((HippoBean)bean));
                        continue;
                    }
                    log.debug("Skipping bean of type '{}' because not of beanMappingClass '{}'", (Object)bean.getClass().getName(), (Object)this.beanMappingClass.getName());
                    continue;
                }
                this.translations.put(locale, (String)((HippoBean)bean));
            }
            catch (ObjectBeanManagerException e) {
                log.warn("Skipping bean: {}", (Throwable)e);
            }
        }
    }
}

