/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.content.beans.standard;

import java.util.HashMap;
import java.util.Map;
import org.hippoecm.hst.content.beans.standard.BeanWrapper;
import org.hippoecm.hst.content.beans.standard.HippoBean;
import org.hippoecm.hst.content.beans.standard.HippoItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeansWrapper<B extends HippoBean> {
    private static Logger log = LoggerFactory.getLogger(BeansWrapper.class);
    private HippoBean bean;
    private Map<String, BeanWrapper<B>> wrappedBeans = new HashMap<String, BeanWrapper<B>>();

    public BeansWrapper(HippoBean bean) {
        this.bean = bean;
    }

    public B getBean(String relPath, Class<B> beanMappingClass) {
        BeanWrapper<Object> wrapped = this.wrappedBeans.get(relPath);
        if (wrapped != null) {
            return wrapped.getBean();
        }
        Object o = this.bean.getBean(relPath);
        if (o == null) {
            if (log.isDebugEnabled()) {
                log.debug("No bean found for relPath '{}' at '{}'", (Object)relPath, (Object)this.bean.getPath());
            }
            wrapped = new BeanWrapper<Object>(null);
            this.wrappedBeans.put(relPath, wrapped);
            return null;
        }
        if (beanMappingClass.isAssignableFrom(o.getClass())) {
            wrapped = new BeanWrapper<HippoBean>((HippoBean)o);
            this.wrappedBeans.put(relPath, wrapped);
            return (B)wrapped.getBean();
        }
        log.warn("Cannot get '" + beanMappingClass.getName() + "' bean for relPath '{}' at '{}' because returned bean is of type '" + o.getClass().getName() + "'", (Object)relPath, (Object)this.bean.getPath());
        wrapped = new BeanWrapper<Object>(null);
        this.wrappedBeans.put(relPath, wrapped);
        return null;
    }

    public void detach() {
        for (BeanWrapper<B> wrapper : this.wrappedBeans.values()) {
            if (wrapper.getBean() == null || !(wrapper.getBean() instanceof HippoItem)) continue;
            ((HippoItem)wrapper.getBean()).detach();
        }
    }
}

