/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.content.beans.standard;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.hippoecm.hst.content.beans.ObjectBeanManagerException;
import org.hippoecm.hst.content.beans.manager.ObjectConverter;
import org.hippoecm.hst.content.beans.standard.HippoAvailableTranslationsBean;
import org.hippoecm.hst.content.beans.standard.HippoBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailableTranslations<K extends HippoBean>
implements HippoAvailableTranslationsBean<K> {
    private static final Logger log = LoggerFactory.getLogger(AvailableTranslations.class);
    private final Node node;
    private final ObjectConverter objectConverter;
    private Map<String, K> translations;
    private Class<K> beanMappingClass;

    public AvailableTranslations(Node node, ObjectConverter objectConverter) {
        this.node = node;
        this.objectConverter = objectConverter;
    }

    public List<String> getAvailableLocales() {
        this.populate();
        return new ArrayList<String>(this.translations.keySet());
    }

    public K getTranslation(String locale) {
        this.populate();
        return (K)((HippoBean)this.translations.get(locale));
    }

    public List<K> getTranslations() {
        this.populate();
        return new ArrayList<K>(this.translations.values());
    }

    public boolean hasTranslation(String locale) {
        this.populate();
        return this.translations.get(locale) != null;
    }

    private void populate() {
        if (this.translations != null) {
            return;
        }
        try {
            this.populateTranslations();
        }
        catch (RepositoryException e) {
            log.warn("Exception while trying to fetch translations.", (Throwable)e);
        }
    }

    public void setBeanMappingClass(Class<K> beanMappingClass) {
        this.beanMappingClass = beanMappingClass;
    }

    private void populateTranslations() throws RepositoryException {
        this.translations = new LinkedHashMap<String, K>();
        if (!this.node.hasProperty("hippotranslation:id")) {
            log.debug("No translations for '{}' since property '{}' not available", (Object)this.node.getPath(), (Object)"hippotranslation:id");
            return;
        }
        String id = this.node.getProperty("hippotranslation:id").getString();
        String xpath = "//element(*,hippotranslation:translated)[hippotranslation:id = '" + id + "']";
        Query query = this.node.getSession().getWorkspace().getQueryManager().createQuery(xpath, "xpath");
        QueryResult result = query.execute();
        NodeIterator nodeIterator = result.getNodes();
        while (nodeIterator.hasNext()) {
            Node translation = nodeIterator.nextNode();
            if (translation == null) continue;
            if (!translation.hasProperty("hippotranslation:locale")) {
                log.debug("Skipping node '{}' because does not contain property '{}'", (Object)translation.getPath(), (Object)"hippotranslation:locale");
                continue;
            }
            String locale = translation.getProperty("hippotranslation:locale").getString();
            try {
                Object bean = this.objectConverter.getObject(translation);
                if (bean == null) continue;
                if (this.beanMappingClass != null) {
                    if (this.beanMappingClass.isAssignableFrom(bean.getClass())) {
                        this.translations.put(locale, (String)((HippoBean)bean));
                        continue;
                    }
                    log.debug("Skipping bean of type '{}' because not of beanMappingClass '{}'", (Object)bean.getClass().getName(), (Object)this.beanMappingClass.getName());
                    continue;
                }
                this.translations.put(locale, (String)((HippoBean)bean));
            }
            catch (ObjectBeanManagerException e) {
                log.warn("Skipping bean: {}", (Throwable)e);
            }
        }
    }
}

