/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.content.beans.query.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hippoecm.hst.content.beans.query.filter.NodeTypeFilter;

public class MixinNodeTypeFilterImpl
implements NodeTypeFilter {
    private List<String> mixinNodeTypeNamesList = new ArrayList<String>();
    private int occur;

    public MixinNodeTypeFilterImpl(String mixinNodeType, int occur) {
        this.mixinNodeTypeNamesList.add(mixinNodeType);
        this.occur = occur;
    }

    public MixinNodeTypeFilterImpl(String[] mixinNodeTypes, int occur) {
        this.mixinNodeTypeNamesList.addAll(Arrays.asList(mixinNodeTypes));
        this.occur = occur;
    }

    public void addNodeTypeName(String nodeTypeName) {
        this.mixinNodeTypeNamesList.add(nodeTypeName);
    }

    public String getJcrExpression() {
        if (this.mixinNodeTypeNamesList.size() == 0) {
            return null;
        }
        StringBuilder where = new StringBuilder("(");
        boolean first = true;
        for (String name : this.mixinNodeTypeNamesList) {
            if (first) {
                where.append("@jcr:mixinTypes='").append(name).append("'");
            } else {
                if (this.occur == 0) {
                    where.append(" and ");
                } else {
                    where.append(" or ");
                }
                where.append("@jcr:mixinTypes='").append(name).append("'");
            }
            first = false;
        }
        where.append(")");
        return where.toString();
    }
}

