/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.content.beans.query.filter;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Session;
import org.hippoecm.hst.content.beans.query.exceptions.FilterException;
import org.hippoecm.hst.content.beans.query.filter.BaseFilter;
import org.hippoecm.hst.content.beans.query.filter.Filter;
import org.hippoecm.hst.site.HstServices;
import org.hippoecm.hst.util.SearchInputParsingUtils;
import org.hippoecm.repository.util.DateTools;

public class FilterImpl
implements Filter {
    private static final String FQCN = FilterImpl.class.getName();
    private StringBuilder jcrExpressionBuilder;
    private boolean negated = false;
    private final Session session;
    private final DateTools.Resolution defaultResolution;
    private List<FilterTypeWrapper> childFilters = new ArrayList<FilterTypeWrapper>();
    private ChildFilterType firstAddedType;

    @Deprecated
    public FilterImpl(Session session) {
        this(session, DateTools.Resolution.MILLISECOND);
        HstServices.getLogger((String)FQCN, (String)FQCN).warn("Use HstQuery#createFilter() or FilterImpl(Session, Resolution) instead of this deprecated constructor. Fast Date Range Searches are not supported with this constructor");
    }

    public FilterImpl(Session session, DateTools.Resolution resolution) {
        this.session = session;
        this.defaultResolution = resolution == null ? DateTools.Resolution.MILLISECOND : resolution;
    }

    public Filter negate() {
        this.negated = !this.negated;
        return this;
    }

    private void addContains(String scope, String fullTextSearch, boolean isNot) throws FilterException {
        scope = this.toXPathProperty(scope, true, "addContains", new String[]{"."});
        if (fullTextSearch == null) {
            throw new FilterException("Not allowed to search on 'null'.");
        }
        String text = fullTextSearch;
        if ("*".equals(text)) {
            if (".".equals(scope)) {
                return;
            }
            this.addNotNull(scope);
            return;
        }
        if (!(text = SearchInputParsingUtils.removeLeadingWildCardsFromWords(text)).equals(fullTextSearch)) {
            HstServices.getLogger((String)FQCN, (String)FQCN).warn("Replaced fullTextSearch '{}' with '{}' as it contained terms that started with a wildcard. Use '{}'.parse(...) to first parse the input.", new Object[]{fullTextSearch, text, SearchInputParsingUtils.class.getName()});
        }
        String jcrExpression = "jcr:contains(" + scope + ", '" + text + "')";
        if (isNot) {
            this.addNotExpression(jcrExpression);
        } else {
            this.addExpression(jcrExpression);
        }
    }

    public void addContains(String scope, String fullTextSearch) throws FilterException {
        this.addContains(scope, fullTextSearch, false);
    }

    public void addNotContains(String scope, String fullTextSearch) throws FilterException {
        this.addContains(scope, fullTextSearch, true);
    }

    private void addBetween(String fieldAttributeName, Object value1, Object value2, boolean isNot) throws FilterException {
        if (value1 == null || value2 == null) {
            throw new FilterException("Not allowed to search on 'null'.");
        }
        if (value1 instanceof Calendar && value2 instanceof Calendar) {
            this.addBetween(fieldAttributeName, (Calendar)value1, (Calendar)value2, this.defaultResolution, isNot);
            return;
        }
        if (value1 instanceof Date && value2 instanceof Date) {
            GregorianCalendar start = new GregorianCalendar();
            start.setTime((Date)value1);
            GregorianCalendar end = new GregorianCalendar();
            end.setTime((Date)value2);
            this.addBetween(fieldAttributeName, start, end, this.defaultResolution, isNot);
            return;
        }
        fieldAttributeName = this.toXPathProperty(fieldAttributeName, true, "addBetween");
        String jcrExpression = "( " + fieldAttributeName + " >= " + this.getStringValue(value1) + " and " + fieldAttributeName + " <= " + this.getStringValue(value2) + ")";
        if (isNot) {
            this.addNotExpression(jcrExpression);
        } else {
            this.addExpression(jcrExpression);
        }
    }

    private void addBetween(String fieldAttributeName, Calendar start, Calendar end, DateTools.Resolution resolution, boolean isNot) throws FilterException {
        String jcrExpression;
        if (start == null || end == null) {
            throw new FilterException("Not allowed to search on 'null'.");
        }
        if (resolution == DateTools.Resolution.MILLISECOND) {
            String xpathProperty = this.toXPathProperty(fieldAttributeName, true, "addBetween");
            jcrExpression = "( " + xpathProperty + " >= " + DateTools.createXPathConstraint((Session)this.session, (Calendar)start) + " and " + xpathProperty + " <= " + DateTools.createXPathConstraint((Session)this.session, (Calendar)end) + ")";
        } else {
            String xpathProperty = this.toXPathProperty(fieldAttributeName, true, "addBetween");
            String xpathPropertyForResolution = DateTools.getPropertyForResolution((String)xpathProperty, (DateTools.Resolution)resolution);
            jcrExpression = "( " + xpathPropertyForResolution + " >= " + DateTools.createXPathConstraint((Session)this.session, (Calendar)start, (DateTools.Resolution)resolution) + " and " + xpathPropertyForResolution + " <= " + DateTools.createXPathConstraint((Session)this.session, (Calendar)end, (DateTools.Resolution)resolution) + ")";
        }
        if (isNot) {
            this.addNotExpression(jcrExpression);
        } else {
            this.addExpression(jcrExpression);
        }
    }

    public void addBetween(String fieldAttributeName, Object value1, Object value2) throws FilterException {
        this.addBetween(fieldAttributeName, value1, value2, false);
    }

    public void addBetween(String fieldAttributeName, Calendar start, Calendar end, DateTools.Resolution resolution) throws FilterException {
        this.addBetween(fieldAttributeName, start, end, resolution, false);
    }

    public void addNotBetween(String fieldAttributeName, Object value1, Object value2) throws FilterException {
        this.addBetween(fieldAttributeName, value1, value2, true);
    }

    public void addNotBetween(String fieldAttributeName, Calendar start, Calendar end, DateTools.Resolution resolution) throws FilterException {
        this.addBetween(fieldAttributeName, start, end, resolution, true);
    }

    private void addConstraintWithOperator(String fieldAttributeName, Object value, String operator, boolean isRangeConstraint) throws FilterException {
        if (value == null) {
            throw new FilterException("Not allowed to search on 'null'.");
        }
        if (isRangeConstraint) {
            if (value instanceof Calendar) {
                this.addConstraintWithOperator(fieldAttributeName, (Calendar)value, this.defaultResolution, operator);
                return;
            }
            if (value instanceof Date) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime((Date)value);
                this.addConstraintWithOperator(fieldAttributeName, cal, this.defaultResolution, operator);
                return;
            }
        }
        String xpathProperty = this.toXPathProperty(fieldAttributeName, true, "operator : " + operator);
        String jcrExpression = xpathProperty + operator + this.getStringValue(value);
        this.addExpression(jcrExpression);
    }

    private void addConstraintWithOperator(String fieldAttributeName, Calendar calendar, DateTools.Resolution resolution, String operator) throws FilterException {
        String jcrExpression;
        if (calendar == null) {
            throw new FilterException("Not allowed to search on 'null'.");
        }
        if (resolution == DateTools.Resolution.MILLISECOND) {
            String xpathProperty = this.toXPathProperty(fieldAttributeName, true, "equal");
            jcrExpression = xpathProperty + operator + DateTools.createXPathConstraint((Session)this.session, (Calendar)calendar);
        } else {
            String xpathProperty = this.toXPathProperty(fieldAttributeName, true, "equal");
            String xpathPropertyForResolution = DateTools.getPropertyForResolution((String)xpathProperty, (DateTools.Resolution)resolution);
            jcrExpression = xpathPropertyForResolution + operator + DateTools.createXPathConstraint((Session)this.session, (Calendar)calendar, (DateTools.Resolution)resolution);
        }
        this.addExpression(jcrExpression);
    }

    public void addEqualTo(String fieldAttributeName, Object value) throws FilterException {
        this.addConstraintWithOperator(fieldAttributeName, value, " = ", false);
    }

    public void addEqualTo(String fieldAttributeName, Calendar calendar, DateTools.Resolution resolution) throws FilterException {
        this.addConstraintWithOperator(fieldAttributeName, calendar, resolution, " = ");
    }

    public void addNotEqualTo(String fieldAttributeName, Object value) throws FilterException {
        this.addConstraintWithOperator(fieldAttributeName, value, " != ", false);
    }

    public void addNotEqualTo(String fieldAttributeName, Calendar calendar, DateTools.Resolution resolution) throws FilterException {
        this.addConstraintWithOperator(fieldAttributeName, calendar, resolution, " != ");
    }

    public void addGreaterOrEqualThan(String fieldAttributeName, Object value) throws FilterException {
        this.addConstraintWithOperator(fieldAttributeName, value, " >= ", true);
    }

    public void addGreaterOrEqualThan(String fieldAttributeName, Calendar calendar, DateTools.Resolution resolution) throws FilterException {
        this.addConstraintWithOperator(fieldAttributeName, calendar, resolution, " >= ");
    }

    public void addGreaterThan(String fieldAttributeName, Object value) throws FilterException {
        this.addConstraintWithOperator(fieldAttributeName, value, " > ", true);
    }

    public void addGreaterThan(String fieldAttributeName, Calendar calendar, DateTools.Resolution resolution) throws FilterException {
        this.addConstraintWithOperator(fieldAttributeName, calendar, resolution, " > ");
    }

    public void addLessOrEqualThan(String fieldAttributeName, Object value) throws FilterException {
        this.addConstraintWithOperator(fieldAttributeName, value, " <= ", true);
    }

    public void addLessOrEqualThan(String fieldAttributeName, Calendar calendar, DateTools.Resolution resolution) throws FilterException {
        this.addConstraintWithOperator(fieldAttributeName, calendar, resolution, " <= ");
    }

    public void addLessThan(String fieldAttributeName, Object value) throws FilterException {
        this.addConstraintWithOperator(fieldAttributeName, value, " < ", true);
    }

    public void addLessThan(String fieldAttributeName, Calendar calendar, DateTools.Resolution resolution) throws FilterException {
        this.addConstraintWithOperator(fieldAttributeName, calendar, resolution, " < ");
    }

    private void addLike(String fieldAttributeName, Object value, boolean isNot) throws FilterException {
        HstServices.getLogger((String)FQCN, (String)FQCN).warn("addLike or addNotLike for FilterImpl is used.  It is strongly recommended to not use this because it blows up queries memory and cpu wise");
        if (value == null) {
            throw new FilterException("Not allowed to search on 'null'.");
        }
        fieldAttributeName = this.toXPathProperty(fieldAttributeName, false, "addLike");
        String jcrExpression = "jcr:like(" + fieldAttributeName + ", '" + value + "')";
        if (isNot) {
            this.addNotExpression(jcrExpression);
        } else {
            this.addExpression(jcrExpression);
        }
    }

    public void addLike(String fieldAttributeName, Object value) throws FilterException {
        this.addLike(fieldAttributeName, value, false);
    }

    public void addNotLike(String fieldAttributeName, Object value) throws FilterException {
        this.addLike(fieldAttributeName, value, true);
    }

    public void addNotNull(String fieldAttributeName) throws FilterException {
        String jcrExpression = fieldAttributeName = this.toXPathProperty(fieldAttributeName, true, "addNotNull");
        this.addExpression(jcrExpression);
    }

    public void addIsNull(String fieldAttributeName) throws FilterException {
        fieldAttributeName = this.toXPathProperty(fieldAttributeName, true, "addIsNull");
        String jcrExpression = "not(" + fieldAttributeName + ")";
        this.addExpression(jcrExpression);
    }

    public void addJCRExpression(String jcrExpression) {
        this.addExpression(jcrExpression);
    }

    public Filter addOrFilter(BaseFilter filter) {
        if (this.firstAddedType == null) {
            this.firstAddedType = ChildFilterType.OR;
        } else if (this.firstAddedType == ChildFilterType.AND) {
            HstServices.getLogger((String)FQCN, (String)FQCN).warn("Mixing AND and OR filters within a single parent Filter: This results in ambiguous searches where the order of AND and OR filters matter");
        }
        this.childFilters.add(new FilterTypeWrapper(filter, false));
        return this;
    }

    private void processOrFilter(BaseFilter filter, StringBuilder builder) {
        if (filter.getJcrExpression() == null || "".equals(filter.getJcrExpression())) {
            return;
        }
        if (builder.length() == 0) {
            builder.append("(").append(filter.getJcrExpression()).append(")");
        } else {
            builder.append(" or ").append("(").append(filter.getJcrExpression()).append(")");
        }
    }

    public Filter addAndFilter(BaseFilter filter) {
        if (this.firstAddedType == null) {
            this.firstAddedType = ChildFilterType.AND;
        } else if (this.firstAddedType == ChildFilterType.OR) {
            HstServices.getLogger((String)FQCN, (String)FQCN).warn("Mixing AND and OR filters within a single parent Filter: This results in ambiguous searches where the order of AND and OR filters matter");
        }
        this.childFilters.add(new FilterTypeWrapper(filter, true));
        return this;
    }

    private void processAndFilter(BaseFilter filter, StringBuilder builder) {
        if (filter.getJcrExpression() == null || "".equals(filter.getJcrExpression())) {
            return;
        }
        if (builder.length() == 0) {
            builder.append("(").append(filter.getJcrExpression()).append(")");
        } else {
            builder.append(" and ").append("(").append(filter.getJcrExpression()).append(")");
        }
    }

    private void addNotExpression(String jcrExpression) {
        if (jcrExpression == null || "".equals(jcrExpression)) {
            return;
        }
        this.addExpression("not(" + jcrExpression + ")");
    }

    private void addExpression(String jcrExpression) {
        if (jcrExpression == null || "".equals(jcrExpression)) {
            return;
        }
        if (this.jcrExpressionBuilder == null) {
            this.jcrExpressionBuilder = new StringBuilder(jcrExpression);
        } else {
            this.jcrExpressionBuilder.append(" and ").append(jcrExpression);
        }
    }

    public String getJcrExpression() {
        StringBuilder originalExpr = this.jcrExpressionBuilder == null ? null : new StringBuilder(this.jcrExpressionBuilder);
        StringBuilder childFiltersExpression = null;
        if (this.childFilters.size() > 0) {
            childFiltersExpression = new StringBuilder();
            this.processChildFilters(childFiltersExpression);
        }
        if (childFiltersExpression != null && childFiltersExpression.length() > 0) {
            if (this.jcrExpressionBuilder == null) {
                this.jcrExpressionBuilder = new StringBuilder(childFiltersExpression);
            } else {
                if (this.firstAddedType == ChildFilterType.AND) {
                    this.jcrExpressionBuilder.append(" and ");
                } else {
                    this.jcrExpressionBuilder.append(" or ");
                }
                this.jcrExpressionBuilder.append((CharSequence)childFiltersExpression);
            }
        }
        if (this.jcrExpressionBuilder == null) {
            return null;
        }
        if (this.negated) {
            String processedExpr = "not(" + this.jcrExpressionBuilder.toString() + ")";
            this.jcrExpressionBuilder = originalExpr == null ? null : new StringBuilder(originalExpr);
            return processedExpr;
        }
        String processedExpr = this.jcrExpressionBuilder.toString();
        this.jcrExpressionBuilder = originalExpr == null ? null : new StringBuilder(originalExpr);
        return processedExpr;
    }

    private void processChildFilters(StringBuilder childFiltersExpression) {
        for (FilterTypeWrapper filter : this.childFilters) {
            if (filter.isAnd()) {
                this.processAndFilter(filter.getFilter(), childFiltersExpression);
                continue;
            }
            this.processOrFilter(filter.getFilter(), childFiltersExpression);
        }
    }

    public String getStringValue(Object value) throws FilterException {
        if (value instanceof String || value instanceof Boolean) {
            return "'" + value.toString() + "'";
        }
        if (value instanceof Long || value instanceof Double) {
            return value.toString();
        }
        if (value instanceof Calendar) {
            return DateTools.createXPathConstraint((Session)this.session, (Calendar)((Calendar)value));
        }
        if (value instanceof Date) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime((Date)value);
            return DateTools.createXPathConstraint((Session)this.session, (Calendar)cal);
        }
        throw new FilterException("Unsupported Object type '" + value.getClass().getName() + "' to query on.");
    }

    String toXPathProperty(String path, boolean childAxisAllowed, String methodName) throws FilterException {
        return this.toXPathProperty(path, childAxisAllowed, methodName, null);
    }

    String toXPathProperty(String path, boolean childAxisAllowed, String methodName, String[] skips) throws FilterException {
        if (path == null) {
            throw new FilterException("Scope is not allowed to be null for '" + methodName + "'");
        }
        if (skips != null) {
            for (String skip : skips) {
                if (!skip.equals(path)) continue;
                return path;
            }
        }
        if (childAxisAllowed) {
            if (path.indexOf("/") > -1) {
                String[] parts = path.split("/");
                StringBuilder newPath = new StringBuilder();
                int i = 0;
                for (String part : parts) {
                    if (++i == parts.length) {
                        if (i > 1) {
                            newPath.append("/");
                        }
                        if (!part.startsWith("@")) {
                            newPath.append("@");
                        }
                        newPath.append(part);
                        continue;
                    }
                    if (part.startsWith("@")) {
                        throw new FilterException("'@' in path only allowed for a property: invalid path: '" + path + "'");
                    }
                    if (i > 1) {
                        newPath.append("/");
                    }
                    newPath.append(part);
                }
                return newPath.toString();
            }
            if (path.startsWith("@")) {
                return path;
            }
            return "@" + path;
        }
        if (path.indexOf("/") > -1) {
            throw new FilterException("Not allowed to use a child path for '" + methodName + "'. Invalid: '" + path + "'");
        }
        if (path.startsWith("@")) {
            return path;
        }
        return "@" + path;
    }

    private static class FilterTypeWrapper {
        private boolean and;
        private BaseFilter filter;

        FilterTypeWrapper(BaseFilter filter, boolean and) {
            this.and = and;
            this.filter = filter;
        }

        private BaseFilter getFilter() {
            return this.filter;
        }

        private boolean isAnd() {
            return this.and;
        }
    }

    private static enum ChildFilterType {
        OR,
        AND;

    }
}

