/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.content.beans.query;

import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import org.hippoecm.hst.content.beans.manager.ObjectConverter;
import org.hippoecm.hst.content.beans.query.HstQueryResult;
import org.hippoecm.hst.content.beans.standard.HippoBeanIterator;
import org.hippoecm.hst.content.beans.standard.HippoBeanIteratorImpl;
import org.hippoecm.repository.api.HippoNodeIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstQueryResultImpl
implements HstQueryResult {
    private static final Logger log = LoggerFactory.getLogger(HstQueryResultImpl.class);
    private QueryResult queryResult;
    private ObjectConverter objectConverter;
    private int totalSize = -2;
    private int size = -2;

    public HstQueryResultImpl(ObjectConverter objectConverter, QueryResult queryResult) {
        this.objectConverter = objectConverter;
        this.queryResult = queryResult;
    }

    public HippoBeanIterator getHippoBeans() {
        try {
            return new HippoBeanIteratorImpl(this.objectConverter, this.queryResult.getNodes());
        }
        catch (RepositoryException e) {
            log.error("RepositoryException. Return null. {}", (Throwable)e);
            return null;
        }
    }

    public int getTotalSize() {
        if (this.totalSize != -2) {
            return this.totalSize;
        }
        try {
            NodeIterator iterator = this.queryResult.getNodes();
            if (iterator instanceof HippoNodeIterator) {
                this.totalSize = (int)((HippoNodeIterator)iterator).getTotalSize();
                if (this.totalSize == -1) {
                    log.error("getTotalSize returned -1 for query. Should not be possible. Fallback to normal getSize()");
                    this.totalSize = this.getSize();
                } else {
                    log.debug("getTotalSize call returned '{}' hits", (Object)this.totalSize);
                }
            } else {
                log.debug("The getTotalSize method only works properly in embedded repository mode. Fallback to normal getSize()");
                this.totalSize = this.getSize();
            }
        }
        catch (RepositoryException e) {
            log.error("RepositoryException. Return 0. {}", (Throwable)e);
            return 0;
        }
        return this.totalSize;
    }

    public int getSize() {
        if (this.size != -2) {
            return this.size;
        }
        try {
            this.size = (int)this.queryResult.getNodes().getSize();
        }
        catch (RepositoryException e) {
            log.error("RepositoryException. Return 0. {}", (Throwable)e);
            return 0;
        }
        return this.size;
    }
}

