/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.content.beans.query;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.Session;
import org.hippoecm.hst.content.beans.manager.ObjectConverter;
import org.hippoecm.hst.content.beans.query.HstQuery;
import org.hippoecm.hst.content.beans.query.HstQueryImpl;
import org.hippoecm.hst.content.beans.query.HstQueryManager;
import org.hippoecm.hst.content.beans.query.exceptions.QueryException;
import org.hippoecm.hst.content.beans.query.filter.IsNodeTypeFilter;
import org.hippoecm.hst.content.beans.query.filter.NodeTypeFilter;
import org.hippoecm.hst.content.beans.query.filter.PrimaryNodeTypeFilterImpl;
import org.hippoecm.hst.content.beans.standard.HippoBean;
import org.hippoecm.repository.util.DateTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstQueryManagerImpl
implements HstQueryManager {
    private static final Logger log = LoggerFactory.getLogger(HstQueryManagerImpl.class);
    private ObjectConverter objectConverter;
    private Session session;
    private final DateTools.Resolution defaultResolution;

    @Deprecated
    public HstQueryManagerImpl(Session session, ObjectConverter objectConverter) {
        this(session, objectConverter, DateTools.Resolution.MILLISECOND);
        log.warn("Using deprecated HstQueryManagerImpl constructor. No Filter.Resolution is specified. Use default Filter.Resolution.EXPENSIVE_PRECISE");
    }

    public HstQueryManagerImpl(Session session, ObjectConverter objectConverter, DateTools.Resolution resolution) {
        this.session = session;
        this.objectConverter = objectConverter;
        this.defaultResolution = resolution;
    }

    public HstQuery createQuery(Node scope) throws QueryException {
        return this.createQuery(scope, (NodeTypeFilter)null);
    }

    public HstQuery createQuery(Node scope, Class<? extends HippoBean> filterBean, boolean includeSubTypes) throws QueryException {
        if (!includeSubTypes) {
            return this.createQuery(scope, filterBean);
        }
        String primaryNodeTypeNameForBean = this.objectConverter.getPrimaryNodeTypeNameFor(filterBean);
        IsNodeTypeFilter isNodeTypeFilter = null;
        if (primaryNodeTypeNameForBean == null) {
            throw new QueryException("Cannot find primaryNodeType for '" + filterBean.getName() + "'.");
        }
        isNodeTypeFilter = new IsNodeTypeFilter(primaryNodeTypeNameForBean);
        return new HstQueryImpl(this.session, this.objectConverter, scope, isNodeTypeFilter);
    }

    public HstQuery createQuery(HippoBean scope) throws QueryException {
        if (scope == null || scope.getNode() == null) {
            return this.createQuery((Node)null);
        }
        return this.createQuery(scope.getNode());
    }

    public HstQuery createQuery(HippoBean scope, Class<? extends HippoBean> filterBean, boolean includeSubTypes) throws QueryException {
        if (scope.getNode() == null) {
            return this.createQuery((Node)null, filterBean, includeSubTypes);
        }
        return this.createQuery(scope.getNode(), filterBean, includeSubTypes);
    }

    public HstQuery createQuery(HippoBean scope, Class<? extends HippoBean> ... filterBeans) throws QueryException {
        if (scope.getNode() == null) {
            return this.createQuery((Node)null, filterBeans);
        }
        return this.createQuery(scope.getNode(), filterBeans);
    }

    public HstQuery createQuery(Node scope, Class<? extends HippoBean> ... filterBeans) throws QueryException {
        ArrayList<String> primaryNodeTypes = new ArrayList<String>();
        for (Class<? extends HippoBean> annotatedBean : filterBeans) {
            String primaryNodeTypeNameForBean = this.objectConverter.getPrimaryNodeTypeNameFor(annotatedBean);
            if (primaryNodeTypeNameForBean == null) {
                throw new QueryException("Cannot find primaryNodeType for '" + annotatedBean.getClass().getName() + "'.");
            }
            primaryNodeTypes.add(primaryNodeTypeNameForBean);
        }
        PrimaryNodeTypeFilterImpl primaryNodeTypeFilter = null;
        if (primaryNodeTypes.size() > 0) {
            primaryNodeTypeFilter = new PrimaryNodeTypeFilterImpl(primaryNodeTypes.toArray(new String[primaryNodeTypes.size()]));
        }
        return this.createQuery(scope, primaryNodeTypeFilter);
    }

    public HstQuery createQuery(Node scope, String nodeType, boolean includeSubTypes) throws QueryException {
        if (nodeType == null) {
            throw new IllegalArgumentException("The node type for query must not be null!");
        }
        if (!includeSubTypes) {
            return this.createQuery(scope, nodeType);
        }
        IsNodeTypeFilter isNodeTypeFilter = new IsNodeTypeFilter(nodeType);
        HstQueryImpl query = new HstQueryImpl(this.session, this.objectConverter, scope, isNodeTypeFilter);
        query.setDefaultResolution(this.defaultResolution);
        return query;
    }

    public HstQuery createQuery(HippoBean scope, String ... primaryNodeTypes) throws QueryException {
        if (scope.getNode() == null) {
            return this.createQuery((Node)null, primaryNodeTypes);
        }
        return this.createQuery(scope.getNode(), primaryNodeTypes);
    }

    public HstQuery createQuery(Node scope, String ... primaryNodeTypes) throws QueryException {
        if (primaryNodeTypes == null) {
            throw new IllegalArgumentException("Primary node types for query must not be null!");
        }
        PrimaryNodeTypeFilterImpl primaryNodeTypeFilter = null;
        primaryNodeTypeFilter = new PrimaryNodeTypeFilterImpl(primaryNodeTypes);
        return this.createQuery(scope, primaryNodeTypeFilter);
    }

    private HstQuery createQuery(Node scope, NodeTypeFilter filter) throws QueryException {
        HstQueryImpl query = new HstQueryImpl(this.session, this.objectConverter, scope, filter);
        query.setDefaultResolution(this.defaultResolution);
        return query;
    }
}

