/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.content.beans.query;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.hippoecm.hst.container.RequestContextProvider;
import org.hippoecm.hst.content.beans.manager.ObjectConverter;
import org.hippoecm.hst.content.beans.query.HstQuery;
import org.hippoecm.hst.content.beans.query.HstQueryResult;
import org.hippoecm.hst.content.beans.query.HstQueryResultImpl;
import org.hippoecm.hst.content.beans.query.exceptions.QueryException;
import org.hippoecm.hst.content.beans.query.filter.BaseFilter;
import org.hippoecm.hst.content.beans.query.filter.Filter;
import org.hippoecm.hst.content.beans.query.filter.FilterImpl;
import org.hippoecm.hst.content.beans.query.filter.IsNodeTypeFilter;
import org.hippoecm.hst.content.beans.query.filter.NodeTypeFilter;
import org.hippoecm.hst.content.beans.standard.HippoBean;
import org.hippoecm.hst.diagnosis.HDC;
import org.hippoecm.hst.diagnosis.Task;
import org.hippoecm.repository.util.DateTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstQueryImpl
implements HstQuery {
    private static final Logger log = LoggerFactory.getLogger(HstQueryImpl.class);
    private ObjectConverter objectConverter;
    private int limit = 1000;
    private int offset = -1;
    private BaseFilter filter;
    private List<Node> scopes = new ArrayList<Node>();
    private List<Node> excludeScopes = new ArrayList<Node>();
    private List<String> orderByList = new ArrayList<String>();
    private NodeTypeFilter nodeTypeFilter;
    private IsNodeTypeFilter isNodeTypeFilter;
    private Session session;
    private DateTools.Resolution defaultResolution;

    public HstQueryImpl(Session session, ObjectConverter objectConverter, Node scope, NodeTypeFilter nodeTypeFilter) {
        this.session = session;
        this.objectConverter = objectConverter;
        if (scope != null) {
            this.scopes.add(scope);
        }
        this.nodeTypeFilter = nodeTypeFilter;
    }

    public HstQueryImpl(Session session, ObjectConverter objectConverter, Node scope, IsNodeTypeFilter isNodeTypeFilter) {
        this.session = session;
        this.objectConverter = objectConverter;
        if (scope != null) {
            this.scopes.add(scope);
        }
        this.isNodeTypeFilter = isNodeTypeFilter;
    }

    public void setDefaultResolution(DateTools.Resolution defaultResolution) {
        this.defaultResolution = defaultResolution;
    }

    public void addOrderByAscending(String fieldNameAttribute) {
        this.orderByList.add("@" + fieldNameAttribute + " ascending");
    }

    public void addOrderByDescending(String fieldNameAttribute) {
        this.orderByList.add("@" + fieldNameAttribute + " descending");
    }

    public Filter createFilter() {
        return new FilterImpl(this.session, this.defaultResolution);
    }

    public BaseFilter getFilter() {
        return this.filter;
    }

    public void setFilter(BaseFilter filter) {
        this.filter = filter;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getQueryAsString(boolean skipDefaultOrderBy) throws QueryException {
        String jcrExpression;
        if (this.scopes == null || this.scopes.size() == 0) {
            throw new QueryException("There must be a scope for a search");
        }
        StringBuilder scopesWhereClause = new StringBuilder();
        for (Node scope : this.scopes) {
            try {
                String identifier = scope.getIdentifier();
                if (scopesWhereClause.length() > 0) {
                    scopesWhereClause.append(" or ");
                }
                scopesWhereClause.append("@").append("hippo:paths").append("='").append(identifier).append("'");
            }
            catch (RepositoryException e) {
                log.warn("RepositoryException while trying to include scope: ", (Throwable)e);
            }
        }
        StringBuilder query = new StringBuilder(256);
        if (scopesWhereClause.length() <= 0) {
            throw new QueryException("No valid scope for search");
        }
        query.append("(").append(scopesWhereClause.toString()).append(")");
        if (RequestContextProvider.get() != null) {
            if (RequestContextProvider.get().isPreview()) {
                query.append(" and (@").append("hippo:availability").append("='preview'").append(")");
            } else {
                query.append(" and (@").append("hippo:availability").append("='live'").append(")");
            }
        }
        query.append(" and not(@jcr:primaryType='nt:frozenNode')");
        if (this.excludeScopes != null && !this.excludeScopes.isEmpty()) {
            StringBuilder excludeExpr = new StringBuilder(80);
            for (Node excludeScope : this.excludeScopes) {
                String scopeUUID = null;
                try {
                    scopeUUID = excludeScope.isNodeType("hippo:facetselect") ? excludeScope.getProperty("hippo:docbase").getString() : excludeScope.getIdentifier();
                }
                catch (RepositoryException e) {
                    log.error("RepositoryException while excluding scope: ", (Throwable)e);
                }
                if (scopeUUID == null) continue;
                if (excludeExpr.length() > 0) {
                    excludeExpr.append(" and ");
                }
                excludeExpr.append("not(@").append("hippo:paths").append("='").append(scopeUUID).append("')");
            }
            if (excludeExpr.length() > 0) {
                if (query.length() == 0) {
                    query.append("(").append(excludeExpr.toString()).append(")");
                } else {
                    query.append(" and (").append(excludeExpr.toString()).append(")");
                }
            }
        }
        if (this.getFilter() != null && (jcrExpression = this.getFilter().getJcrExpression()) != null) {
            if (query.length() == 0) {
                query.append(jcrExpression);
            } else {
                query.append(" and (").append(jcrExpression).append(")");
            }
        }
        if (this.nodeTypeFilter != null && (jcrExpression = this.nodeTypeFilter.getJcrExpression()) != null) {
            if (query.length() == 0) {
                query.append(jcrExpression);
            } else {
                query.append(" and (").append(jcrExpression).append(")");
            }
        }
        if (this.isNodeTypeFilter != null) {
            query.insert(0, this.isNodeTypeFilter.getJcrExpression() + "[");
        } else {
            query.insert(0, "//*[");
        }
        query.append("]");
        if (this.orderByList.size() > 0) {
            query.append(" order by ");
            boolean first = true;
            for (String orderBy : this.orderByList) {
                if (!first) {
                    query.append(",");
                }
                query.append(orderBy);
                first = false;
            }
        } else if (!skipDefaultOrderBy) {
            query.append(" order by @jcr:score descending ");
        }
        log.debug("Query to execute is '{}'", (Object)query.toString());
        return query.toString();
    }

    public String getQuery() throws QueryException {
        return this.getQueryAsString(false);
    }

    public String toString() {
        String query = null;
        try {
            query = this.getQuery();
        }
        catch (QueryException e) {
            log.warn("cannot get query : ", (Object)e.getMessage());
        }
        return super.toString() + " = " + query;
    }

    public HstQueryResult execute() throws QueryException {
        Task queryTask = null;
        try {
            String query = this.getQuery();
            if (HDC.isStarted()) {
                queryTask = HDC.getCurrentTask().startSubtask("HstQuery");
                queryTask.setAttribute("query", (Object)query);
            }
            QueryManager jcrQueryManager = this.getQueryManager();
            Query jcrQuery = jcrQueryManager.createQuery(query, "xpath");
            if (this.offset > -1) {
                jcrQuery.setOffset((long)this.offset);
            }
            if (this.limit > -1) {
                jcrQuery.setLimit((long)this.limit);
            }
            QueryResult queryResult = jcrQuery.execute();
            HstQueryResultImpl hstQueryResultImpl = new HstQueryResultImpl(this.objectConverter, queryResult);
            return hstQueryResultImpl;
        }
        catch (InvalidQueryException e) {
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
        catch (LoginException e) {
            log.warn("LoginException. Return null : {}", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (queryTask != null) {
                queryTask.stop();
            }
        }
        return null;
    }

    private QueryManager getQueryManager() throws RepositoryException, QueryException {
        for (Node scope : this.scopes) {
            if (scope == null) continue;
            return scope.getSession().getWorkspace().getQueryManager();
        }
        throw new QueryException("Unable to get QueryManager");
    }

    public void addScopes(List<HippoBean> scopes) {
        for (HippoBean scope : scopes) {
            if (scope != null) {
                Node newScope = scope.getNode();
                this.removeNodeFromList(newScope, this.excludeScopes);
                this.scopes.add(newScope);
                continue;
            }
            this.scopes.add(null);
        }
    }

    public void addScopes(Node[] scopes) {
        for (Node scope : scopes) {
            if (scope != null) {
                this.removeNodeFromList(scope, this.excludeScopes);
                this.scopes.add(scope);
                continue;
            }
            this.scopes.add(null);
        }
    }

    public void setSkipInvalidScopes(boolean skipInvalidScopes) {
        log.info("skipInvalidScopes is deprecated since 2.25.02. No need to set it any more");
    }

    public void excludeScopes(List<HippoBean> scopes) {
        for (HippoBean scope : scopes) {
            if (scope == null) continue;
            Node scopeNode = scope.getNode();
            this.removeNodeFromList(scopeNode, this.scopes);
            this.excludeScopes.add(scopeNode);
        }
    }

    public void excludeScopes(Node[] scopes) {
        for (Node scope : scopes) {
            if (scope == null) continue;
            this.removeNodeFromList(scope, this.scopes);
            this.excludeScopes.add(scope);
        }
    }

    private void removeNodeFromList(Node remove, List<Node> fromList) {
        ArrayList<Node> removeItems = new ArrayList<Node>();
        for (Node node : fromList) {
            try {
                if (!node.isSame((Item)remove)) continue;
                removeItems.add(node);
            }
            catch (RepositoryException e) {
                log.error("Ignore remove from list. Repository exception: ", (Object)e.getMessage());
            }
        }
        fromList.removeAll(removeItems);
    }
}

