/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.content.beans.manager.workflow;

import java.rmi.RemoteException;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.content.beans.ContentNodeBinder;
import org.hippoecm.hst.content.beans.ObjectBeanPersistenceException;
import org.hippoecm.hst.content.beans.manager.ObjectBeanManagerImpl;
import org.hippoecm.hst.content.beans.manager.ObjectConverter;
import org.hippoecm.hst.content.beans.manager.workflow.WorkflowCallbackHandler;
import org.hippoecm.hst.content.beans.manager.workflow.WorkflowPersistenceManager;
import org.hippoecm.hst.content.beans.standard.HippoBean;
import org.hippoecm.hst.content.beans.standard.HippoDocumentBean;
import org.hippoecm.hst.content.beans.standard.HippoFolderBean;
import org.hippoecm.hst.util.NodeUtils;
import org.hippoecm.repository.api.Document;
import org.hippoecm.repository.api.HippoWorkspace;
import org.hippoecm.repository.api.StringCodec;
import org.hippoecm.repository.api.StringCodecFactory;
import org.hippoecm.repository.api.Workflow;
import org.hippoecm.repository.api.WorkflowException;
import org.hippoecm.repository.api.WorkflowManager;
import org.hippoecm.repository.standardworkflow.DefaultWorkflow;
import org.hippoecm.repository.standardworkflow.EditableWorkflow;
import org.hippoecm.repository.standardworkflow.FolderWorkflow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowPersistenceManagerImpl
extends ObjectBeanManagerImpl
implements WorkflowPersistenceManager {
    private static final Logger log = LoggerFactory.getLogger(WorkflowPersistenceManagerImpl.class);
    protected Map<String, ContentNodeBinder> contentNodeBinders;
    protected String folderNodeTypeName = "hippostd:folder";
    protected String folderNodeWorkflowCategory = "threepane";
    protected String documentNodeWorkflowCategory = "default";
    protected String documentAdditionWorkflowCategory = "new-document";
    protected String folderAdditionWorkflowCategory = "new-folder";
    protected WorkflowCallbackHandler workflowCallbackHandler;
    protected StringCodec uriEncoding = new StringCodecFactory.UriEncoding();
    protected String defaultWorkflowCategory = "core";

    public WorkflowPersistenceManagerImpl(Session session, ObjectConverter objectConverter) {
        this(session, objectConverter, null);
    }

    public WorkflowPersistenceManagerImpl(Session session, ObjectConverter objectConverter, Map<String, ContentNodeBinder> contentNodeBinders) {
        super(session, objectConverter);
        this.contentNodeBinders = contentNodeBinders;
    }

    public String createAndReturn(String absPath, String nodeTypeName, String name, boolean autoCreateFolders) throws ObjectBeanPersistenceException {
        try {
            Node parentFolderNode = this.getExistingFolderNode(absPath);
            if (parentFolderNode == null) {
                if (!autoCreateFolders) {
                    throw new ObjectBeanPersistenceException("The folder node is not found on the path: " + absPath);
                }
                parentFolderNode = this.createMissingFolders(absPath);
            }
            return this.createNodeByWorkflow(parentFolderNode, nodeTypeName, name);
        }
        catch (ObjectBeanPersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectBeanPersistenceException((Throwable)e);
        }
    }

    protected Node createMissingFolders(String absPath) throws ObjectBeanPersistenceException {
        try {
            Node rootNode;
            String[] folderNames = StringUtils.split((String)absPath, (String)"/");
            Node curNode = rootNode = this.session.getRootNode();
            for (String folderName : folderNames) {
                String folderNodeName = this.uriEncoding.encode(folderName);
                String folderNodePath = curNode == rootNode ? "/" + folderNodeName : curNode.getPath() + "/" + folderNodeName;
                Node existingFolderNode = this.getExistingFolderNode(folderNodePath);
                curNode = existingFolderNode == null ? this.session.getNode(this.createNodeByWorkflow(curNode, this.folderNodeTypeName, folderName)) : existingFolderNode;
                if (!NodeUtils.isDereferenceable((Node)(curNode = NodeUtils.getCanonicalNode((Node)curNode)))) continue;
                curNode = NodeUtils.getDeref((Node)curNode);
            }
            return curNode;
        }
        catch (ObjectBeanPersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectBeanPersistenceException((Throwable)e);
        }
    }

    protected String createNodeByWorkflow(Node folderNode, String nodeTypeName, String name) throws ObjectBeanPersistenceException {
        try {
            folderNode = this.getCanonicalNode(folderNode);
            Workflow wf = this.getWorkflow(this.folderNodeWorkflowCategory, folderNode);
            if (wf instanceof FolderWorkflow) {
                String nodeName;
                String added;
                FolderWorkflow fwf = (FolderWorkflow)wf;
                String category = this.documentAdditionWorkflowCategory;
                if (nodeTypeName.equals(this.folderNodeTypeName)) {
                    Object protypesMap;
                    category = this.folderAdditionWorkflowCategory;
                    if (fwf.hints() != null && fwf.hints().get("prototypes") != null && (protypesMap = fwf.hints().get("prototypes")) instanceof Map) {
                        for (Map.Entry o : ((Map)protypesMap).entrySet()) {
                            Map.Entry entry = o;
                            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof Set) || !((Set)entry.getValue()).contains(this.folderNodeTypeName)) continue;
                            category = (String)entry.getKey();
                            break;
                        }
                    }
                }
                if ((added = fwf.add(category, nodeTypeName, nodeName = this.uriEncoding.encode(name))) == null) {
                    throw new ObjectBeanPersistenceException("Failed to add document/folder for type '" + nodeTypeName + "'. Make sure there is a prototype.");
                }
                Node addedNode = folderNode.getSession().getNode(added);
                if (!nodeName.equals(name)) {
                    DefaultWorkflow defaultWorkflow = (DefaultWorkflow)this.getWorkflow(this.defaultWorkflowCategory, addedNode);
                    defaultWorkflow.localizeName(name);
                }
                if (this.documentAdditionWorkflowCategory.equals(category)) {
                    if (!addedNode.hasProperty("hippo:availability") || addedNode.getProperty("hippo:availability").getValues().length != 1 || !"preview".equals(addedNode.getProperty("hippo:availability").getValues()[0].getString())) {
                        addedNode.setProperty("hippo:availability", new String[]{"preview"});
                    }
                    if (addedNode.isNodeType("hippostd:publishable")) {
                        addedNode.setProperty("hippostd:state", "unpublished");
                    }
                    if (addedNode.isNodeType("hippostd:publishableSummary")) {
                        addedNode.setProperty("hippostd:stateSummary", "new");
                    }
                    addedNode.getSession().save();
                }
                return added;
            }
            throw new ObjectBeanPersistenceException("Can't create folder " + name + " [" + nodeTypeName + "] in the folder " + folderNode.getPath() + ", because there is no FolderWorkflow possible on the folder node: " + wf);
        }
        catch (RepositoryException e) {
            throw new ObjectBeanPersistenceException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new ObjectBeanPersistenceException((Throwable)e);
        }
        catch (WorkflowException e) {
            throw new ObjectBeanPersistenceException((Throwable)e);
        }
    }

    public void update(Object content) throws ObjectBeanPersistenceException {
        ContentNodeBinder binder;
        if (content instanceof HippoBean) {
            binder = null;
            if (this.contentNodeBinders != null && !this.contentNodeBinders.isEmpty()) {
                try {
                    HippoBean contentBean = (HippoBean)content;
                    Node contentNode = contentBean.getNode();
                    contentNode = this.getCanonicalNode(contentNode);
                    binder = this.contentNodeBinders.get(contentNode.getPrimaryNodeType().getName());
                }
                catch (Exception e) {
                    throw new ObjectBeanPersistenceException((Throwable)e);
                }
            }
            if (binder == null && content instanceof ContentNodeBinder) {
                binder = (ContentNodeBinder)content;
            }
        } else {
            throw new ObjectBeanPersistenceException("The content object parameter should be an instance of HippoBean.");
        }
        this.update(content, binder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(Object content, ContentNodeBinder customContentNodeBinder) throws ObjectBeanPersistenceException {
        if (!(content instanceof HippoBean)) throw new ObjectBeanPersistenceException("The content object parameter should be an instance of HippoBean.");
        String path = null;
        try {
            HippoBean contentBean = (HippoBean)content;
            path = contentBean.getPath();
            Node contentNode = contentBean.getNode();
            contentNode = this.getCanonicalNode(contentNode);
            Workflow wf = this.getWorkflow(this.documentNodeWorkflowCategory, contentNode);
            if (wf != null) {
                if (customContentNodeBinder != null) {
                    boolean changed;
                    if (!(wf instanceof EditableWorkflow)) throw new ObjectBeanPersistenceException("The workflow is not a EditableWorkflow for " + path + ": " + wf);
                    EditableWorkflow ewf = (EditableWorkflow)wf;
                    Document document = ewf.obtainEditableInstance();
                    String uuid = document.getIdentity();
                    if (uuid != null && !"".equals(uuid)) {
                        contentNode = this.session.getNodeByIdentifier(uuid);
                    }
                    if (changed = customContentNodeBinder.bind(content, contentNode)) {
                        contentNode.getSession().save();
                        ewf = (EditableWorkflow)this.getWorkflow(this.documentNodeWorkflowCategory, contentNode);
                        document = ewf.commitEditableInstance();
                        if (this.workflowCallbackHandler == null) return;
                        wf = this.getWorkflow(this.documentNodeWorkflowCategory, document);
                        if (wf == null) throw new ObjectBeanPersistenceException("Workflow callback cannot be called because the workflow is null. ");
                        this.workflowCallbackHandler.processWorkflow(wf);
                        return;
                    } else {
                        ewf.disposeEditableInstance();
                    }
                    return;
                } else {
                    if (this.workflowCallbackHandler == null || wf == null) return;
                    this.workflowCallbackHandler.processWorkflow(wf);
                }
                return;
            } else {
                log.warn("Could not obtain workflow '{}' for '{}'. Make sure that user '{}' has enough workflow rights on the node.", new Object[]{this.documentNodeWorkflowCategory, path, contentNode.getSession().getUserID()});
            }
            return;
        }
        catch (ObjectBeanPersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            if (path == null) throw new ObjectBeanPersistenceException((Throwable)e);
            throw new ObjectBeanPersistenceException("Exception while trying to update '" + path + "'", (Throwable)e);
        }
    }

    public void remove(Object content) throws ObjectBeanPersistenceException {
        if (!(content instanceof HippoBean)) {
            throw new ObjectBeanPersistenceException("The content object parameter should be an instance of HippoBean.");
        }
        try {
            HippoBean beanToRemove = (HippoBean)content;
            Node canonicalNodeToRemove = this.getCanonicalNode(beanToRemove.getNode());
            if (beanToRemove instanceof HippoDocumentBean) {
                canonicalNodeToRemove = canonicalNodeToRemove.getParent();
            } else if (!(beanToRemove instanceof HippoFolderBean)) {
                throw new ObjectBeanPersistenceException("Don't know how to persist a bean of type '" + beanToRemove.getClass().getName() + "'");
            }
            String nodeNameToRemove = canonicalNodeToRemove.getName();
            Node folderNodeToRemoveFrom = canonicalNodeToRemove.getParent();
            Workflow wf = this.getWorkflow(this.folderNodeWorkflowCategory, folderNodeToRemoveFrom);
            if (!(wf instanceof FolderWorkflow)) {
                throw new ObjectBeanPersistenceException("The workflow is not a FolderWorkflow for " + folderNodeToRemoveFrom.getPath() + ": " + wf);
            }
            FolderWorkflow fwf = (FolderWorkflow)wf;
            fwf.delete(nodeNameToRemove);
        }
        catch (Exception e) {
            throw new ObjectBeanPersistenceException((Throwable)e);
        }
    }

    public void save() throws ObjectBeanPersistenceException {
        try {
            this.session.save();
        }
        catch (Exception e) {
            throw new ObjectBeanPersistenceException((Throwable)e);
        }
    }

    public void refresh() throws ObjectBeanPersistenceException {
        this.refresh(false);
    }

    public void refresh(boolean keepChanges) throws ObjectBeanPersistenceException {
        try {
            this.session.refresh(keepChanges);
        }
        catch (Exception e) {
            throw new ObjectBeanPersistenceException((Throwable)e);
        }
    }

    public void setFolderNodeTypeName(String folderNodeTypeName) {
        this.folderNodeTypeName = folderNodeTypeName;
    }

    public String getFolderNodeTypeName() {
        return this.folderNodeTypeName;
    }

    public String getFolderNodeWorkflowCategory() {
        return this.folderNodeWorkflowCategory;
    }

    public void setFolderNodeWorkflowCategory(String folderNodeWorkflowCategory) {
        this.folderNodeWorkflowCategory = folderNodeWorkflowCategory;
    }

    public String getDocumentNodeWorkflowCategory() {
        return this.documentNodeWorkflowCategory;
    }

    public void setDocumentNodeWorkflowCategory(String documentNodeWorkflowCategory) {
        this.documentNodeWorkflowCategory = documentNodeWorkflowCategory;
    }

    public String getFolderAdditionWorkflowCategory() {
        return this.folderAdditionWorkflowCategory;
    }

    public void setFolderAdditionWorkflowCategory(String folderAdditionWorkflowCategory) {
        this.folderAdditionWorkflowCategory = folderAdditionWorkflowCategory;
    }

    public String getDocumentAdditionWorkflowCategory() {
        return this.documentAdditionWorkflowCategory;
    }

    public void setDocumentAdditionWorkflowCategory(String documentAdditionWorkflowCategory) {
        this.documentAdditionWorkflowCategory = documentAdditionWorkflowCategory;
    }

    public void setWorkflowCallbackHandler(WorkflowCallbackHandler<? extends Workflow> workflowCallbackHandler) {
        this.workflowCallbackHandler = workflowCallbackHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workflow getWorkflow(String category, Node node) throws RepositoryException {
        Workspace workspace = this.session.getWorkspace();
        ClassLoader workspaceClassloader = workspace.getClass().getClassLoader();
        ClassLoader currentClassloader = Thread.currentThread().getContextClassLoader();
        try {
            if (workspaceClassloader != currentClassloader) {
                Thread.currentThread().setContextClassLoader(workspaceClassloader);
            }
            WorkflowManager wfm = ((HippoWorkspace)workspace).getWorkflowManager();
            Workflow workflow = wfm.getWorkflow(category, node);
            return workflow;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.warn("Exception in workflow", (Throwable)e);
            } else {
                log.warn("Exception in workflow: {}", (Object)e.toString());
            }
        }
        finally {
            if (workspaceClassloader != currentClassloader) {
                Thread.currentThread().setContextClassLoader(currentClassloader);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workflow getWorkflow(String category, Document document) throws RepositoryException {
        Workspace workspace = this.session.getWorkspace();
        ClassLoader workspaceClassloader = workspace.getClass().getClassLoader();
        ClassLoader currentClassloader = Thread.currentThread().getContextClassLoader();
        try {
            if (workspaceClassloader != currentClassloader) {
                Thread.currentThread().setContextClassLoader(workspaceClassloader);
            }
            WorkflowManager wfm = ((HippoWorkspace)workspace).getWorkflowManager();
            Workflow workflow = wfm.getWorkflow(category, document);
            return workflow;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.warn("Exception in workflow", (Throwable)e);
            } else {
                log.warn("Exception in workflow: {}", (Object)e.toString());
            }
            Workflow workflow = null;
            return workflow;
        }
        finally {
            if (workspaceClassloader != currentClassloader) {
                Thread.currentThread().setContextClassLoader(currentClassloader);
            }
        }
    }

    private Node getCanonicalNode(Node folderNode) throws ObjectBeanPersistenceException {
        if ((folderNode = NodeUtils.getCanonicalNode((Node)folderNode)) == null) {
            throw new ObjectBeanPersistenceException("Cannot perform workflow on a node that does not have a canonical version");
        }
        return folderNode;
    }

    private Node getExistingFolderNode(String absPath) throws RepositoryException {
        if (!this.session.nodeExists(absPath)) {
            return null;
        }
        Node node = this.session.getNode(absPath);
        Node candidateNode = null;
        if (this.session.getRootNode().isSame((Item)node)) {
            return this.session.getRootNode();
        }
        Node parentNode = node.getParent();
        NodeIterator nodeIt = parentNode.getNodes(node.getName());
        while (nodeIt.hasNext()) {
            Node siblingNode = nodeIt.nextNode();
            if (this.isDocument(siblingNode)) continue;
            candidateNode = siblingNode;
            break;
        }
        if (candidateNode == null) {
            return null;
        }
        Node canonicalFolderNode = NodeUtils.getCanonicalNode(candidateNode);
        if (NodeUtils.isDereferenceable((Node)canonicalFolderNode)) {
            canonicalFolderNode = NodeUtils.getDeref((Node)canonicalFolderNode);
        }
        if (canonicalFolderNode == null) {
            return null;
        }
        if (this.isDocument(canonicalFolderNode)) {
            return null;
        }
        return canonicalFolderNode;
    }

    private boolean isDocument(Node node) throws RepositoryException {
        Node parentNode;
        if (NodeUtils.isNodeType((Node)node, (String[])new String[]{"hippo:handle", "hippo:hardhandle"})) {
            return true;
        }
        return NodeUtils.isNodeType((Node)node, (String[])new String[]{"hippo:document", "hippo:harddocument"}) && !this.session.getRootNode().isSame((Item)node) && NodeUtils.isNodeType((Node)(parentNode = node.getParent()), (String[])new String[]{"hippo:handle", "hippo:hardhandle"});
    }
}

