/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.content.beans.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.content.beans.NodeAware;
import org.hippoecm.hst.content.beans.ObjectBeanManagerException;
import org.hippoecm.hst.content.beans.manager.ObjectConverter;
import org.hippoecm.hst.content.beans.manager.ObjectConverterAware;
import org.hippoecm.hst.content.beans.standard.HippoBean;
import org.hippoecm.hst.service.ServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectConverterImpl
implements ObjectConverter {
    private static final Logger log = LoggerFactory.getLogger(ObjectConverterImpl.class);
    protected Map<String, Class<? extends HippoBean>> jcrPrimaryNodeTypeBeanPairs;
    protected Map<Class<? extends HippoBean>, String> jcrBeanPrimaryNodeTypePairs;
    protected String[] fallBackJcrNodeTypes;

    public ObjectConverterImpl(Map<String, Class<? extends HippoBean>> jcrPrimaryNodeTypeBeanPairs, String[] fallBackJcrNodeTypes) {
        this.jcrPrimaryNodeTypeBeanPairs = jcrPrimaryNodeTypeBeanPairs;
        this.jcrBeanPrimaryNodeTypePairs = new HashMap<Class<? extends HippoBean>, String>();
        for (Map.Entry<String, Class<? extends HippoBean>> entry : jcrPrimaryNodeTypeBeanPairs.entrySet()) {
            this.jcrBeanPrimaryNodeTypePairs.put(entry.getValue(), entry.getKey());
        }
        if (fallBackJcrNodeTypes != null) {
            this.fallBackJcrNodeTypes = new String[fallBackJcrNodeTypes.length];
            System.arraycopy(fallBackJcrNodeTypes, 0, this.fallBackJcrNodeTypes, 0, fallBackJcrNodeTypes.length);
        }
    }

    public Object getObject(Session session, String path) throws ObjectBeanManagerException {
        if (StringUtils.isEmpty((String)path) || !path.startsWith("/")) {
            log.warn("Illegal argument for '{}' : not an absolute path", (Object)path);
            return null;
        }
        String relPath = path.substring(1);
        try {
            return this.getObject(session.getRootNode(), relPath);
        }
        catch (RepositoryException re) {
            throw new ObjectBeanManagerException("Impossible to get the object at " + path, (Throwable)re);
        }
    }

    public Object getObject(Node node, String relPath) throws ObjectBeanManagerException {
        if (StringUtils.isEmpty((String)relPath) || relPath.startsWith("/")) {
            log.warn("'{}' is not a valid relative path. Return null.", (Object)relPath);
            return null;
        }
        if (node == null) {
            log.warn("Node is null. Cannot get document with relative path '{}'", (Object)relPath);
            return null;
        }
        String nodePath = null;
        try {
            nodePath = node.getPath();
            if (!node.hasNode(relPath)) {
                log.info("Cannot get object for node '{}' with relPath '{}'", (Object)nodePath, (Object)relPath);
                return null;
            }
            Node relNode = node.getNode(relPath);
            if (relNode.isNodeType("hippo:handle")) {
                if (relNode.hasNode(relNode.getName())) {
                    return this.getObject(relNode.getNode(relNode.getName()));
                }
                log.info("Cannot get object for node '{}' with relPath '{}'", (Object)nodePath, (Object)relPath);
                return null;
            }
            return this.getObject(relNode);
        }
        catch (RepositoryException e) {
            if (log.isDebugEnabled()) {
                log.warn("Cannot get object for node '" + nodePath + "' with relPath '" + relPath + "'", (Throwable)e);
            } else {
                log.warn("Cannot get object for node '{}' with relPath '{}'", (Object)nodePath, (Object)relPath);
            }
            return null;
        }
    }

    public Object getObject(String uuid, Session session) throws ObjectBeanManagerException {
        this.checkUUID(uuid);
        try {
            Node node = session.getNodeByIdentifier(uuid);
            return this.getObject(node);
        }
        catch (ItemNotFoundException e) {
            log.warn("ItemNotFoundException for uuid '{}'. Return null.", (Object)uuid);
        }
        catch (RepositoryException e) {
            log.error("RepositoryException for uuid '{}' : {}. Return null.", (Object)uuid, (Object)e);
        }
        return null;
    }

    public Object getObject(String uuid, Node node) throws ObjectBeanManagerException {
        try {
            return this.getObject(uuid, node.getSession());
        }
        catch (RepositoryException e) {
            log.error("RepositoryException {}. Return null.", (Throwable)e);
            return null;
        }
    }

    public Object getObject(Node node) throws ObjectBeanManagerException {
        String path;
        String jcrPrimaryNodeType;
        Object object = null;
        try {
            if (node.isNodeType("hippo:handle")) {
                if (node.hasNode(node.getName())) {
                    return this.getObject(node.getNode(node.getName()));
                }
                return null;
            }
            jcrPrimaryNodeType = node.getPrimaryNodeType().getName();
            Class<? extends HippoBean> proxyInterfacesOrDelegateeClass = this.jcrPrimaryNodeTypeBeanPairs.get(jcrPrimaryNodeType);
            if (proxyInterfacesOrDelegateeClass == null) {
                for (String fallBackJcrPrimaryNodeType : this.fallBackJcrNodeTypes) {
                    if (!node.isNodeType(fallBackJcrPrimaryNodeType) || (proxyInterfacesOrDelegateeClass = this.jcrPrimaryNodeTypeBeanPairs.get(fallBackJcrPrimaryNodeType)) == null) continue;
                    log.debug("No bean found for {}, using fallback class  {} instead", (Object)jcrPrimaryNodeType, proxyInterfacesOrDelegateeClass);
                    break;
                }
            }
            if (proxyInterfacesOrDelegateeClass != null) {
                object = ServiceFactory.create(node, proxyInterfacesOrDelegateeClass);
                if (object instanceof NodeAware) {
                    ((NodeAware)object).setNode(node);
                }
                if (object instanceof ObjectConverterAware) {
                    ((ObjectConverterAware)object).setObjectConverter((ObjectConverter)this);
                }
                return object;
            }
            path = node.getPath();
        }
        catch (RepositoryException e) {
            throw new ObjectBeanManagerException("Impossible to get the object from the repository", (Throwable)e);
        }
        catch (Exception e) {
            throw new ObjectBeanManagerException("Impossible to convert the node", (Throwable)e);
        }
        log.warn("No Descriptor found for node '{}'. Cannot return a Bean for '{}'.", (Object)path, (Object)jcrPrimaryNodeType);
        return null;
    }

    public String getPrimaryObjectType(Node node) throws ObjectBeanManagerException {
        String path;
        String jcrPrimaryNodeType;
        try {
            if (node.isNodeType("hippo:handle")) {
                if (node.hasNode(node.getName())) {
                    return this.getPrimaryObjectType(node.getNode(node.getName()));
                }
                return null;
            }
            jcrPrimaryNodeType = node.getPrimaryNodeType().getName();
            boolean isObjectType = this.jcrPrimaryNodeTypeBeanPairs.containsKey(jcrPrimaryNodeType);
            if (!isObjectType) {
                for (String fallBackJcrPrimaryNodeType : this.fallBackJcrNodeTypes) {
                    if (!node.isNodeType(fallBackJcrPrimaryNodeType) || !(isObjectType = this.jcrPrimaryNodeTypeBeanPairs.containsKey(fallBackJcrPrimaryNodeType))) continue;
                    log.debug("No primary node type found for {}, using fallback type {} instead", (Object)jcrPrimaryNodeType, (Object)fallBackJcrPrimaryNodeType);
                    jcrPrimaryNodeType = fallBackJcrPrimaryNodeType;
                    break;
                }
            }
            if (isObjectType) {
                return jcrPrimaryNodeType;
            }
            path = node.getPath();
        }
        catch (RepositoryException e) {
            throw new ObjectBeanManagerException("Impossible to get the node from the repository", (Throwable)e);
        }
        catch (Exception e) {
            throw new ObjectBeanManagerException("Impossible to determine node type for node", (Throwable)e);
        }
        log.warn("No Descriptor found for node '{}'. Cannot return a matching node type for '{}'.", (Object)path, (Object)jcrPrimaryNodeType);
        return null;
    }

    private void checkUUID(String uuid) throws ObjectBeanManagerException {
        try {
            UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectBeanManagerException("Uuid is not parseable to a valid uuid: '" + uuid + "'");
        }
    }

    public Class<? extends HippoBean> getAnnotatedClassFor(String jcrPrimaryNodeType) {
        return this.jcrPrimaryNodeTypeBeanPairs.get(jcrPrimaryNodeType);
    }

    public String getPrimaryNodeTypeNameFor(Class<? extends HippoBean> hippoBean) {
        return this.jcrBeanPrimaryNodeTypePairs.get(hippoBean);
    }
}

