/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.util;

public class XmlUtils {
    private static final int HEX = 16;
    private static final String[] KNOWN_ENTITIES = new String[]{"gt", "amp", "lt", "apos", "quot"};

    private XmlUtils() {
    }

    public static String encode(String value) {
        StringBuffer sb = new StringBuffer();
        int len = value.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '&': {
                    int nextSemi = value.indexOf(";", i);
                    if (nextSemi < 0 || !XmlUtils.isReference(value.substring(i, nextSemi + 1))) {
                        sb.append("&amp;");
                        continue block7;
                    }
                    sb.append('&');
                    continue block7;
                }
                default: {
                    if (!XmlUtils.isLegalCharacter(c)) continue block7;
                    sb.append(c);
                }
            }
        }
        return sb.substring(0);
    }

    public static boolean isReference(String ent) {
        if (ent.charAt(0) != '&' || !ent.endsWith(";")) {
            return false;
        }
        if (ent.charAt(1) == '#') {
            if (ent.charAt(2) == 'x') {
                try {
                    Integer.parseInt(ent.substring(3, ent.length() - 1), 16);
                    return true;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
            try {
                Integer.parseInt(ent.substring(2, ent.length() - 1));
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        String name = ent.substring(1, ent.length() - 1);
        for (int i = 0; i < KNOWN_ENTITIES.length; ++i) {
            if (!name.equals(KNOWN_ENTITIES[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isLegalCharacter(char c) {
        if (c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        if (c < ' ') {
            return false;
        }
        if (c <= '\ud7ff') {
            return true;
        }
        if (c < '\ue000') {
            return false;
        }
        return c <= '\ufffd';
    }
}

