/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.hippoecm.hst.core.component.WrapperElement;
import org.hippoecm.hst.util.XmlUtils;

public class WrapperElementUtils {
    private WrapperElementUtils() {
    }

    public static String toString(WrapperElement wrapperElement) {
        StringWriter writer = new StringWriter(80);
        try {
            WrapperElementUtils.writeWrapperElement(writer, wrapperElement, null, 0, 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public static void writeWrapperElement(Writer writer, WrapperElement wrapperElement, char[] contentBuffer, int off, int len) throws IOException {
        WrapperElementUtils.writeWrapperElementStart(writer, wrapperElement);
        String textContent = wrapperElement.getTextContent();
        if (textContent != null) {
            writer.write(XmlUtils.encode(textContent));
        }
        if (contentBuffer != null) {
            writer.write(contentBuffer, off, len);
        }
        WrapperElementUtils.writeWrapperElementEnd(writer, wrapperElement);
    }

    private static void writeWrapperElementStart(Writer writer, WrapperElement wrapperElement) throws IOException {
        writer.write(60);
        writer.write(wrapperElement.getTagName());
        for (Map.Entry entry : wrapperElement.getAttributeMap().entrySet()) {
            writer.write(32);
            writer.write((String)entry.getKey());
            writer.write("=\"");
            writer.write(XmlUtils.encode((String)entry.getValue()));
            writer.write("\"");
        }
        writer.write(62);
    }

    private static void writeWrapperElementEnd(Writer writer, WrapperElement wrapperElement) throws IOException {
        writer.write("</");
        writer.write(wrapperElement.getTagName());
        writer.write(62);
    }

    private static void writeWrapperElementEnd(OutputStream out, WrapperElement wrapperElement) throws IOException {
        out.write("</".getBytes());
        out.write(wrapperElement.getTagName().getBytes());
        out.write(62);
    }

    public static void writeWrapperElement(OutputStream out, String encoding, WrapperElement wrapperElement, byte[] contentBuffer, int off, int len) throws IOException {
        OutputStreamWriter writer = null;
        writer = encoding == null ? new OutputStreamWriter(out) : new OutputStreamWriter(out, encoding);
        WrapperElementUtils.writeWrapperElementStart(writer, wrapperElement);
        String textContent = wrapperElement.getTextContent();
        if (textContent != null) {
            writer.write(XmlUtils.encode(textContent));
        }
        writer.flush();
        writer = null;
        if (contentBuffer != null) {
            out.write(contentBuffer, off, len);
        }
        WrapperElementUtils.writeWrapperElementEnd(out, wrapperElement);
    }
}

