/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.util;

import java.util.BitSet;
import org.hippoecm.hst.diagnosis.Task;
import org.hippoecm.hst.logging.Logger;
import org.hippoecm.hst.site.HstServices;

public class TaskLogFormatter {
    public static String getTaskLog(Task task) {
        Logger log = HstServices.getLogger(TaskLogFormatter.class.getName());
        StringBuilder sb = new StringBuilder(256);
        TaskLogFormatter.appendTaskLog(sb, task, 0, new BitSet(0), false, log);
        return sb.toString();
    }

    private static void appendTaskLog(StringBuilder sb, Task task, int depth, BitSet bitset, boolean lastChild, Logger log) {
        BitSet hidePipeAt = new BitSet(depth);
        hidePipeAt.or(bitset);
        for (int i = 0; i < depth; ++i) {
            if (i > 0) {
                if (hidePipeAt.get(i)) {
                    sb.append(" ");
                } else {
                    sb.append("|");
                }
            }
            sb.append("  ");
        }
        if (depth > 0) {
            if (lastChild) {
                sb.append("`");
                hidePipeAt.set(depth);
            } else {
                sb.append("|");
            }
        }
        try {
            String msg = "- " + task.getName() + " (" + task.getDurationTimeMillis() + "ms): " + task.getAttributeMap();
            sb.append(msg).append('\n');
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.warn("Exception during writing task", e);
            }
            log.warn("Exception during writing task : {}", (Object)e.toString());
        }
        int count = 0;
        for (Task childTask : task.getChildTasks()) {
            if (++count == task.getChildTasks().size()) {
                TaskLogFormatter.appendTaskLog(sb, childTask, depth + 1, hidePipeAt, true, log);
                continue;
            }
            TaskLogFormatter.appendTaskLog(sb, childTask, depth + 1, hidePipeAt, false, log);
        }
    }
}

