/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.util;

import java.lang.reflect.Method;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public class ServletConfigUtils {
    private ServletConfigUtils() {
    }

    public static String getInitParameter(ServletConfig servletConfig, ServletContext servletContext, String paramName, String defaultValue) {
        String value = null;
        if (servletConfig != null) {
            value = servletConfig.getInitParameter(paramName);
        }
        if (value == null && servletContext != null) {
            value = servletContext.getInitParameter(paramName);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static String getInitParameter(String paramName, String defaultValue, Object ... configs) {
        String value = null;
        if (configs != null) {
            for (Object config : configs) {
                if (config != null) {
                    try {
                        Method method = config.getClass().getMethod("getInitParameter", String.class);
                        value = (String)method.invoke(config, paramName);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                if (value != null) break;
            }
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static boolean isEmpty(String s) {
        return s == null || "".equals(s);
    }

    public static boolean isBlank(String s) {
        return s == null || "".equals(s.trim());
    }
}

