/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.util;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;

public class PropertyDefinitionUtils {
    private static final String ANY_NAME = "*";

    private PropertyDefinitionUtils() {
    }

    public static PropertyDefinition getPropertyDefinition(NodeType nodeType, String propertyName) {
        return PropertyDefinitionUtils.getPropertyDefinition(nodeType, propertyName, 0);
    }

    public static PropertyDefinition getPropertyDefinition(NodeType nodeType, String propertyName, int requiredPropertyType) {
        PropertyDefinition[] pd = nodeType.getPropertyDefinitions();
        PropertyDefinition candidate = null;
        for (int i = 0; i < pd.length; ++i) {
            if (propertyName.equals(pd[i].getName())) {
                return pd[i];
            }
            if (candidate != null || !PropertyDefinitionUtils.isResidualPropertyDefinition(pd[i]) || requiredPropertyType != 0 && requiredPropertyType != pd[i].getRequiredType()) continue;
            candidate = pd[i];
        }
        return candidate;
    }

    public static PropertyDefinition getPropertyDefinition(Node node, String propertyName) throws RepositoryException {
        return PropertyDefinitionUtils.getPropertyDefinition(node, propertyName, 0);
    }

    public static PropertyDefinition getPropertyDefinition(Node node, String propertyName, int requiredPropertyType) throws RepositoryException {
        NodeType nt = node.getPrimaryNodeType();
        PropertyDefinition propDef = PropertyDefinitionUtils.getPropertyDefinition(nt, propertyName, requiredPropertyType);
        if (propDef != null && !PropertyDefinitionUtils.isResidualPropertyDefinition(propDef)) {
            return propDef;
        }
        NodeType[] mixins = node.getMixinNodeTypes();
        if (mixins == null || mixins.length == 0) {
            return propDef;
        }
        for (int i = 0; i < mixins.length; ++i) {
            PropertyDefinition candidate = PropertyDefinitionUtils.getPropertyDefinition(mixins[i], propertyName, requiredPropertyType);
            if (candidate == null) continue;
            if (!PropertyDefinitionUtils.isResidualPropertyDefinition(candidate)) {
                return candidate;
            }
            if (propDef != null) continue;
            propDef = candidate;
        }
        return propDef;
    }

    public static boolean isResidualPropertyDefinition(PropertyDefinition pd) {
        String name = pd.getName();
        return ANY_NAME.equals(name);
    }
}

