/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.hippoecm.hst.logging.Logger;
import org.hippoecm.hst.site.HstServices;
import org.hippoecm.repository.api.NodeNameCodec;

public class PathUtils {
    private static final String LOGGER_CATEGORY_NAME = PathUtils.class.getName();
    private static final String HTML_SUFFIX = ".html";
    private static final String SLASH_ENCODED = "__slash__";

    private PathUtils() {
    }

    public static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String encodePath(String rewrite) {
        int start = 0;
        if (rewrite.startsWith("/")) {
            start = 1;
        }
        String[] uriParts = rewrite.split("/");
        StringBuilder encodedPath = new StringBuilder();
        for (int i = start; i < uriParts.length - 1; ++i) {
            encodedPath.append("/").append(PathUtils.encodePart(uriParts[i]));
        }
        int last = uriParts.length - 1;
        if (last > 0) {
            if (uriParts[last].indexOf(47) > 0) {
                uriParts[last] = uriParts[last].replaceAll("\\/", SLASH_ENCODED);
            }
            if (uriParts[last].equals(uriParts[last - 1]) && !uriParts[last].contains(".")) {
                encodedPath.append(HTML_SUFFIX);
            } else {
                encodedPath.append("/").append(PathUtils.encodePart(uriParts[last]));
            }
        }
        return encodedPath.toString();
    }

    public static String decodePath(String path) {
        if (path == null || "".equals(path) || "/".equals(path)) {
            return "/";
        }
        int start = 0;
        if (path.startsWith("/")) {
            start = 1;
        }
        String[] uriParts = path.split("/");
        StringBuilder decodedUrl = new StringBuilder();
        for (int i = start; i < uriParts.length - 1; ++i) {
            decodedUrl.append("/").append(PathUtils.decodePart(uriParts[i]));
        }
        int last = uriParts.length - 1;
        if (last > 0) {
            String lastPart = uriParts[last];
            if (lastPart.contains(SLASH_ENCODED)) {
                lastPart = lastPart.replaceAll(SLASH_ENCODED, "/");
            }
            if (lastPart.endsWith(HTML_SUFFIX) && !lastPart.equals(uriParts[last - 1])) {
                String name = PathUtils.decodePart(lastPart.substring(0, lastPart.length() - HTML_SUFFIX.length()));
                decodedUrl.append("/").append(name);
                decodedUrl.append("/").append(name);
            } else {
                decodedUrl.append("/").append(PathUtils.decodePart(lastPart));
            }
        }
        return decodedUrl.toString();
    }

    private static String encodePart(String part) {
        String name = NodeNameCodec.decode((String)part);
        try {
            if (name.indexOf(47) > 0) {
                return URLEncoder.encode(name.replaceAll("\\/", SLASH_ENCODED), "utf-8");
            }
            return URLEncoder.encode(name, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            Logger logger = HstServices.getLogger(LOGGER_CATEGORY_NAME);
            logger.error("Missing utf-8 codec?", (Throwable)e);
            return "";
        }
    }

    private static String decodePart(String part) {
        try {
            String name = URLDecoder.decode(part, "utf-8");
            if (name.contains(SLASH_ENCODED)) {
                return NodeNameCodec.encode((String)name.replaceAll(SLASH_ENCODED, "/"));
            }
            return NodeNameCodec.encode((String)name);
        }
        catch (UnsupportedEncodingException e) {
            Logger logger = HstServices.getLogger(LOGGER_CATEGORY_NAME);
            logger.error("Missing utf-8 codec?", (Throwable)e);
            return "";
        }
    }
}

