/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hippoecm.hst.configuration.components.HstComponentInfo;
import org.hippoecm.hst.core.component.HstComponentException;
import org.hippoecm.hst.core.container.PageErrors;

public class PageErrorUtils {
    private PageErrorUtils() {
    }

    public static Collection<HstComponentException> getExceptionsByComponentClassName(PageErrors pageErrors, String className) {
        for (HstComponentInfo componentInfo : pageErrors.getComponentInfos()) {
            if (!componentInfo.getComponentClassName().equals(className)) continue;
            return pageErrors.getComponentExceptions(componentInfo);
        }
        return Collections.emptyList();
    }

    public static Collection<HstComponentException> getExceptionsByComponentName(PageErrors pageErrors, String name) {
        for (HstComponentInfo componentInfo : pageErrors.getComponentInfos()) {
            if (!componentInfo.getName().equals(name)) continue;
            return pageErrors.getComponentExceptions(componentInfo);
        }
        return Collections.emptyList();
    }

    public static Collection<HstComponentException> getExceptionsByComponentId(PageErrors pageErrors, String id) {
        for (HstComponentInfo componentInfo : pageErrors.getComponentInfos()) {
            if (!componentInfo.getId().equals(id)) continue;
            return pageErrors.getComponentExceptions(componentInfo);
        }
        return Collections.emptyList();
    }

    public static Collection<HstComponentInfo> getComponentInfosByCauseType(PageErrors pageErrors, Class<? extends Throwable> causeType) {
        List<HstComponentInfo> componentInfos = null;
        block0: for (HstComponentInfo componentInfo : pageErrors.getComponentInfos()) {
            for (HstComponentException exception : pageErrors.getComponentExceptions(componentInfo)) {
                Throwable cause = exception.getCause();
                if (cause == null || !causeType.isAssignableFrom(cause.getClass())) continue;
                if (componentInfos == null) {
                    componentInfos = new ArrayList<HstComponentInfo>();
                }
                componentInfos.add(componentInfo);
                continue block0;
            }
        }
        if (componentInfos == null) {
            componentInfos = Collections.emptyList();
        }
        return componentInfos;
    }

    public static Collection<HstComponentException> getExceptionsByCauseType(PageErrors pageErrors, HstComponentInfo componentInfo, Class<? extends Throwable> causeType) {
        List<HstComponentException> exceptions = null;
        for (HstComponentException exception : pageErrors.getComponentExceptions(componentInfo)) {
            Throwable cause = exception.getCause();
            if (cause == null || !causeType.isAssignableFrom(cause.getClass())) continue;
            if (exceptions == null) {
                exceptions = new ArrayList<HstComponentException>();
            }
            exceptions.add(exception);
        }
        if (exceptions == null) {
            exceptions = Collections.emptyList();
        }
        return exceptions;
    }

    public static Collection<HstComponentException> getExceptionsByCauseType(PageErrors pageErrors, Class<? extends Throwable> causeType) {
        List<HstComponentException> exceptions = null;
        for (HstComponentException exception : pageErrors.getAllComponentExceptions()) {
            Throwable cause = exception.getCause();
            if (cause == null || !causeType.isAssignableFrom(cause.getClass())) continue;
            if (exceptions == null) {
                exceptions = new ArrayList<HstComponentException>();
            }
            exceptions.add(exception);
        }
        if (exceptions == null) {
            exceptions = Collections.emptyList();
        }
        return exceptions;
    }
}

