/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.util;

import java.util.UUID;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.hippoecm.hst.site.HstServices;
import org.hippoecm.repository.api.HippoNode;

public class NodeUtils {
    private static final String LOGGER_CATEGORY_NAME = NodeUtils.class.getName();

    public static Node getCanonicalNode(Node node) {
        if (node instanceof HippoNode) {
            HippoNode hnode = (HippoNode)node;
            try {
                Node canonical = hnode.getCanonicalNode();
                if (canonical == null) {
                    HstServices.getLogger(LOGGER_CATEGORY_NAME).debug("Cannot get canonical node for '{}'. This means there is no phyiscal equivalence of the virtual node. Return null", (Object)node.getPath());
                }
                return canonical;
            }
            catch (RepositoryException e) {
                HstServices.getLogger(LOGGER_CATEGORY_NAME).error("Repository exception while fetching canonical node. Return null", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return node;
    }

    public static boolean isDereferenceable(Node node) throws RepositoryException {
        return node.isNodeType("hippo:facetselect") || node.isNodeType("hippo:mirror");
    }

    public static Node getDeref(Node mirrorNode) {
        String docBaseUUID = null;
        try {
            if (!NodeUtils.isDereferenceable(mirrorNode)) {
                HstServices.getLogger(LOGGER_CATEGORY_NAME).info("Cannot deref a node that is not of (sub)type '{}' or '{}'. Return null", (Object)"hippo:facetselect", (Object)"hippo:mirror");
                return null;
            }
            docBaseUUID = mirrorNode.getProperty("hippo:docbase").getString();
            try {
                UUID.fromString(docBaseUUID);
            }
            catch (IllegalArgumentException e) {
                HstServices.getLogger(LOGGER_CATEGORY_NAME).warn("Docbase cannot be parsed to a valid uuid. Return null");
                return null;
            }
            return mirrorNode.getSession().getNodeByIdentifier(docBaseUUID);
        }
        catch (ItemNotFoundException e) {
            String path = null;
            try {
                path = mirrorNode.getPath();
            }
            catch (RepositoryException e1) {
                HstServices.getLogger(LOGGER_CATEGORY_NAME).error("RepositoryException, cannot return deferenced node: {}", (Throwable)e1);
            }
            HstServices.getLogger(LOGGER_CATEGORY_NAME).info("ItemNotFoundException, cannot return deferenced node because docbase uuid '{}' cannot be found. The docbase property is at '{}/hippo:docbase'. Return null", (Object)docBaseUUID, (Object)path);
        }
        catch (RepositoryException e) {
            HstServices.getLogger(LOGGER_CATEGORY_NAME).error("RepositoryException, cannot return deferenced node: {}", (Throwable)e);
        }
        return null;
    }

    public static boolean isNodeType(Node node, String nodeTypeName) throws RepositoryException {
        return nodeTypeName != null && node.isNodeType(nodeTypeName);
    }

    public static boolean isNodeType(Node node, String ... nodeTypeNames) throws RepositoryException {
        if (node == null) {
            return false;
        }
        if (nodeTypeNames != null) {
            for (String nodeTypeName : nodeTypeNames) {
                if (!node.isNodeType(nodeTypeName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPrimaryNodeType(Node node, String ... primaryNodeTypeNames) throws RepositoryException {
        if (primaryNodeTypeNames != null) {
            String primaryNodeTypeName = node.getPrimaryNodeType().getName();
            for (String nodeTypeName : primaryNodeTypeNames) {
                if (!primaryNodeTypeName.equals(nodeTypeName)) continue;
                return true;
            }
        }
        return false;
    }
}

