/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.util;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.hippoecm.repository.api.HippoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrSessionUtils {
    private static final Logger log = LoggerFactory.getLogger(JcrSessionUtils.class);

    private JcrSessionUtils() {
    }

    public static String[] getPendingChangePaths(Session session, boolean prune) throws RepositoryException {
        return JcrSessionUtils.getPendingChangePaths(session, session.getRootNode(), prune);
    }

    public static String[] getPendingChangePaths(Session session, Node node, boolean prune) throws RepositoryException {
        HippoSession hippoSession = JcrSessionUtils.getHippoSession(session);
        NodeIterator pendingNodes = hippoSession.pendingChanges(node, "nt:base", prune);
        ArrayList<String> changePaths = new ArrayList<String>();
        while (pendingNodes.hasNext()) {
            changePaths.add(pendingNodes.nextNode().getPath());
        }
        return changePaths.toArray(new String[changePaths.size()]);
    }

    public static HippoSession getHippoSession(Session session) throws RepositoryException, IllegalArgumentException {
        if (!(session instanceof HippoSession)) {
            Session nonProxiedSession = session.getRootNode().getSession();
            if (!(nonProxiedSession instanceof HippoSession)) {
                log.error("Session not instance of HippoSession. Cannot get pending changes");
                throw new IllegalArgumentException("Session not instance of HippoSession. Cannot get pending changes");
            }
            return (HippoSession)nonProxiedSession;
        }
        return (HippoSession)session;
    }
}

