/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.util;

import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;

public class HstSiteMapUtils {
    private HstSiteMapUtils() {
    }

    public static String getPath(HstSiteMapItem siteMapItem) {
        StringBuilder path = new StringBuilder(siteMapItem.getValue());
        while (siteMapItem.getParentItem() != null) {
            siteMapItem = siteMapItem.getParentItem();
            path.insert(0, "/").insert(0, siteMapItem.getValue());
        }
        return path.toString();
    }

    public static String getPath(HstSiteMapItem siteMapItem, String relPath) {
        StringBuilder path = new StringBuilder(siteMapItem.getValue());
        while (siteMapItem.getParentItem() != null) {
            siteMapItem = siteMapItem.getParentItem();
            path.insert(0, "/").insert(0, siteMapItem.getValue());
        }
        if (relPath == null) {
            return path.toString();
        }
        if (relPath.startsWith("/")) {
            path.append(relPath);
        } else {
            path.append("/").append(relPath);
        }
        return path.toString();
    }

    public static String getPath(Mount mount, String refIdOrPath) {
        if (refIdOrPath == null) {
            return null;
        }
        if (mount.getHstSite() == null || mount.getHstSite().getSiteMap() == null) {
            return refIdOrPath;
        }
        HstSiteMapItem siteMapItemByRefId = mount.getHstSite().getSiteMap().getSiteMapItemByRefId(refIdOrPath);
        if (siteMapItemByRefId != null) {
            return HstSiteMapUtils.getPath(siteMapItemByRefId);
        }
        return refIdOrPath;
    }

    public static String getPath(Mount mount, HstSiteMapItem siteMapItem, String refIdOrRelPath) {
        HstSiteMapItem siteMapItemByRefId;
        if (refIdOrRelPath != null && (siteMapItemByRefId = mount.getHstSite().getSiteMap().getSiteMapItemByRefId(refIdOrRelPath)) != null) {
            return HstSiteMapUtils.getPath(siteMapItemByRefId);
        }
        if (siteMapItem == null) {
            return null;
        }
        return HstSiteMapUtils.getPath(siteMapItem, refIdOrRelPath);
    }
}

