/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.hippoecm.hst.core.component.HstComponentException;
import org.hippoecm.hst.core.component.HstRequest;
import org.hippoecm.hst.core.component.HstResponse;
import org.hippoecm.hst.core.linking.HstLink;
import org.hippoecm.hst.core.linking.HstLinkCreator;
import org.hippoecm.hst.core.request.HstRequestContext;

public class HstResponseUtils {
    private HstResponseUtils() {
    }

    public static void sendRedirect(HstRequest request, HstResponse response, String path) {
        HstResponseUtils.sendRedirect(request, response, path, null, null);
    }

    public static void sendRedirect(HstRequest request, HstResponse response, String path, Map<String, String[]> queryParams) {
        HstResponseUtils.sendRedirect(request, response, path, queryParams, null);
    }

    public static void sendRedirect(HstRequest request, HstResponse response, String path, Map<String, String[]> queryParams, String characterEncoding) {
        HstRequestContext requestContext = request.getRequestContext();
        HstLinkCreator linkCreator = requestContext.getHstLinkCreator();
        HstLink link = linkCreator.create(path, requestContext.getResolvedMount().getMount());
        if (link == null) {
            throw new HstComponentException("Can not redirect.");
        }
        String urlString = link.toUrlForm(request.getRequestContext(), false);
        if (urlString == null) {
            throw new HstComponentException("Can not redirect.");
        }
        if (queryParams != null && !queryParams.isEmpty()) {
            try {
                StringBuilder urlBuilder;
                if (characterEncoding == null) {
                    characterEncoding = "ISO-8859-1";
                }
                boolean firstParamDone = (urlBuilder = new StringBuilder(80).append(urlString)).indexOf("?") >= 0;
                for (Map.Entry<String, String[]> entry : queryParams.entrySet()) {
                    String name = entry.getKey();
                    for (String value : entry.getValue()) {
                        urlBuilder.append(firstParamDone ? "&" : "?").append(name).append("=").append(URLEncoder.encode(value, characterEncoding));
                        firstParamDone = true;
                    }
                }
                urlString = urlBuilder.toString();
            }
            catch (UnsupportedEncodingException e) {
                throw new HstComponentException((Throwable)e);
            }
        }
        try {
            response.sendRedirect(urlString);
        }
        catch (IOException e) {
            throw new HstComponentException("Could not redirect. ", (Throwable)e);
        }
    }
}

