/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.core.component.HstRequest;
import org.hippoecm.hst.core.component.HstResponse;
import org.hippoecm.hst.core.component.HstURL;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.core.request.ResolvedMount;

public class HstRequestUtils {
    private static final Pattern MATRIX_PARAMS_PATTERN = Pattern.compile(";[^\\/]*");

    private HstRequestUtils() {
    }

    public static HstRequest getHstRequest(HttpServletRequest servletRequest) {
        HstRequest hstRequest = (HstRequest)servletRequest.getAttribute("org.hippoecm.hst.container.request");
        if (hstRequest == null && servletRequest instanceof HstRequest) {
            hstRequest = (HstRequest)servletRequest;
        }
        return hstRequest;
    }

    public static HstResponse getHstResponse(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        HstResponse hstResponse = (HstResponse)servletRequest.getAttribute("org.hippoecm.hst.container.response");
        if (hstResponse == null && servletResponse instanceof HstResponse) {
            hstResponse = (HstResponse)servletResponse;
        }
        return hstResponse;
    }

    public static HstRequestContext getHstRequestContext(HttpServletRequest servletRequest) {
        return (HstRequestContext)servletRequest.getAttribute("org.hippoecm.hst.core.request.HstRequestContext");
    }

    public static String getRequestURI(HttpServletRequest request, boolean excludeMatrixParameters) {
        String requestURI = request.getRequestURI();
        if (excludeMatrixParameters) {
            return HstRequestUtils.removeAllMatrixParams(requestURI);
        }
        return requestURI;
    }

    public static String getRequestPath(HttpServletRequest request) {
        return HstRequestUtils.getDecodedPath(null, request, null, false);
    }

    public static String getRequestPath(HttpServletRequest request, String characterEncoding) {
        return HstRequestUtils.getDecodedPath(null, request, characterEncoding, false);
    }

    public static String getPathInfo(ResolvedMount mount, HttpServletRequest request) {
        return HstRequestUtils.getDecodedPath(mount, request, null, true);
    }

    public static String getPathInfo(ResolvedMount mount, HttpServletRequest request, String characterEncoding) {
        return HstRequestUtils.getDecodedPath(mount, request, characterEncoding, true);
    }

    private static String getDecodedPath(ResolvedMount mount, HttpServletRequest request, String characterEncoding, boolean stripMountPath) {
        String requestURI = HstRequestUtils.getRequestURI(request, true);
        String encodePathInfo = requestURI.substring(request.getContextPath().length());
        if (stripMountPath) {
            if (mount == null) {
                throw new IllegalArgumentException("Cannot strip the mountPath when the resolved Mount is null");
            }
            String ignoredPrefix = mount.getMatchingIgnoredPrefix();
            if (ignoredPrefix != null) {
                encodePathInfo = encodePathInfo.substring(ignoredPrefix.length() + 1);
            }
            encodePathInfo = encodePathInfo.substring(mount.getResolvedMountPath().length());
        }
        if (characterEncoding == null && (characterEncoding = request.getCharacterEncoding()) == null) {
            characterEncoding = "ISO-8859-1";
        }
        try {
            return URLDecoder.decode(encodePathInfo, characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Invalid character encoding: " + characterEncoding, e);
        }
    }

    public static String[] getRequestHosts(HttpServletRequest request, boolean checkRenderHost) {
        String host = null;
        if (checkRenderHost) {
            host = HstRequestUtils.getRenderingHost(request);
        }
        if (host == null) {
            host = request.getHeader("X-Forwarded-Host");
        }
        if (host != null) {
            String[] hosts = host.split(",");
            for (int i = 0; i < hosts.length; ++i) {
                hosts[i] = hosts[i].trim();
            }
            return hosts;
        }
        host = request.getHeader("Host");
        if (host != null && !"".equals(host)) {
            return new String[]{host};
        }
        int serverPort = request.getServerPort();
        HstRequest hstRequest = HstRequestUtils.getHstRequest(request);
        if (hstRequest != null) {
            Mount mount = hstRequest.getRequestContext().getResolvedMount().getMount();
            serverPort = mount.isPortInUrl() ? mount.getPort() : 0;
        }
        host = serverPort == 80 || serverPort == 443 || serverPort <= 0 ? request.getServerName() : request.getServerName() + ":" + serverPort;
        return new String[]{host};
    }

    public static String getRenderingHost(HttpServletRequest request) {
        int portNumber;
        String farthestHostName;
        String hostName = HstRequestUtils.getRenderingHostName(request);
        if (hostName == null) {
            return null;
        }
        if (!hostName.contains(":") && (farthestHostName = HstRequestUtils.getFarthestRequestHost(request, false)).contains(":") && (portNumber = Integer.parseInt(farthestHostName.substring(farthestHostName.indexOf(":") + 1))) != 80 && portNumber != 443) {
            hostName = hostName + ":" + portNumber;
        }
        return hostName;
    }

    private static String getRenderingHostName(HttpServletRequest request) {
        String forceClientHost = request.getParameter("FORCE_CLIENT_HOST");
        if (forceClientHost == null) {
            forceClientHost = request.getHeader("FORCE_CLIENT_HOST");
        }
        if (Boolean.parseBoolean(forceClientHost) == Boolean.TRUE) {
            return null;
        }
        String requestParam = request.getParameter("org.hippoecm.hst.container.render_host");
        if (requestParam != null) {
            return requestParam;
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            return (String)session.getAttribute("org.hippoecm.hst.container.render_host");
        }
        return null;
    }

    public static String[] getRequestHosts(HttpServletRequest request) {
        return HstRequestUtils.getRequestHosts(request, true);
    }

    public static String getFarthestRequestHost(HttpServletRequest request) {
        return HstRequestUtils.getRequestHosts(request)[0];
    }

    public static String getFarthestRequestHost(HttpServletRequest request, boolean checkRenderHost) {
        return HstRequestUtils.getRequestHosts(request, checkRenderHost)[0];
    }

    public static String getFarthestRequestScheme(HttpServletRequest request) {
        String scheme = request.getHeader("X-Forwarded-Proto");
        if (scheme != null && scheme.length() > 0) {
            return scheme;
        }
        scheme = request.getHeader("X-Forwarded-Scheme");
        if (scheme != null && scheme.length() > 0) {
            return scheme;
        }
        String sslEnabled = request.getHeader("X-SSL-Enabled");
        if (sslEnabled == null) {
            sslEnabled = request.getHeader("Front-End-Https");
        }
        if (sslEnabled != null && (sslEnabled.equalsIgnoreCase("on") || sslEnabled.equalsIgnoreCase("yes") || sslEnabled.equalsIgnoreCase("1"))) {
            return "https";
        }
        return request.getScheme();
    }

    public static String getRequestServerName(HttpServletRequest request) {
        String requestHost = HstRequestUtils.getFarthestRequestHost(request);
        if (requestHost == null) {
            return request.getServerName();
        }
        int offset = requestHost.indexOf(58);
        if (offset != -1) {
            return requestHost.substring(0, offset);
        }
        return requestHost;
    }

    public static int getRequestServerPort(HttpServletRequest request) {
        String requestHost = HstRequestUtils.getFarthestRequestHost(request);
        if (requestHost == null) {
            return request.getServerPort();
        }
        int offset = requestHost.indexOf(58);
        if (offset != -1) {
            return Integer.parseInt(requestHost.substring(offset + 1));
        }
        return "https".equals(request.getScheme()) ? 443 : 80;
    }

    public static String[] getRemoteAddrs(HttpServletRequest request) {
        String xff = request.getHeader("X-Forwarded-For");
        if (xff != null) {
            String[] addrs = xff.split(",");
            for (int i = 0; i < addrs.length; ++i) {
                addrs[i] = addrs[i].trim();
            }
            return addrs;
        }
        return new String[]{request.getRemoteAddr()};
    }

    public static String getFarthestRemoteAddr(HttpServletRequest request) {
        return HstRequestUtils.getRemoteAddrs(request)[0];
    }

    public static Map<String, String[]> parseQueryString(HttpServletRequest request) {
        Map<String, String[]> queryParamMap = null;
        String queryString = request.getQueryString();
        if (queryString == null) {
            queryParamMap = Collections.emptyMap();
        } else {
            queryParamMap = new LinkedHashMap();
            String[] paramPairs = queryString.split("&");
            String paramName = null;
            for (String paramPair : paramPairs) {
                String[] paramNameAndValue = paramPair.split("=");
                if (paramNameAndValue.length <= 0) continue;
                paramName = paramNameAndValue[0];
                queryParamMap.put(paramName, null);
            }
            for (Map.Entry<String, String[]> entry : queryParamMap.entrySet()) {
                entry.setValue(request.getParameterValues(entry.getKey()));
            }
        }
        return queryParamMap;
    }

    public static String removeAllMatrixParams(String uri) {
        Matcher matcher = MATRIX_PARAMS_PATTERN.matcher(uri);
        return matcher.replaceAll("");
    }

    public static String createURLWithExplicitSchemeForRequest(String scheme, Mount mount, HttpServletRequest request) {
        String contextPath = "";
        if (mount.isContextPathInUrl() && mount.onlyForContextPath() != null) {
            contextPath = mount.onlyForContextPath();
        }
        StringBuilder url = new StringBuilder(scheme).append("://").append(HstRequestUtils.getFarthestRequestHost(request, false)).append(contextPath).append(request.getRequestURI().substring(request.getContextPath().length()));
        if (request.getQueryString() != null) {
            url.append("?").append(request.getQueryString());
        }
        return url.toString();
    }

    public static String getFullyQualifiedHstURL(HstRequestContext requestContext, HstURL hstUrl, boolean escapeXml) {
        int port;
        StringBuilder urlBuilder = new StringBuilder(80);
        String scheme = HstRequestUtils.getFarthestRequestScheme(requestContext.getServletRequest());
        Mount mount = requestContext.getResolvedMount().getMount();
        int n = port = mount.getPort() == 0 ? requestContext.getBaseURL().getPortNumber() : mount.getPort();
        if (!mount.isPortInUrl() || "http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443) {
            urlBuilder.append(scheme).append("://").append(mount.getVirtualHost().getHostName());
        } else {
            urlBuilder.append(scheme).append("://").append(mount.getVirtualHost().getHostName()).append(':').append(port);
        }
        if (escapeXml) {
            urlBuilder.append(HstRequestUtils.escapeXml(hstUrl.toString()));
        } else {
            urlBuilder.append(hstUrl.toString());
        }
        return urlBuilder.toString();
    }

    public static String escapeXml(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("\"", "&#034;");
        str = str.replaceAll("'", "&#039;");
        return str;
    }
}

