/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hippoecm.hst.core.component.HeadElement;
import org.hippoecm.hst.util.XmlUtils;

public class HeadElementUtils {
    private static final int HEX = 16;
    private static final String[] KNOWN_ENTITIES = new String[]{"gt", "amp", "lt", "apos", "quot"};
    private static final Set<String> EXPANDABLE_HEAD_ELEMENT_TAG_NAME_SET = new HashSet<String>(Arrays.asList("SCRIPT", "STYLE", "TITLE"));
    private static final Set<String> PREFORMATTED_HEAD_ELEMENT_TAG_NAME_SET = new HashSet<String>(Arrays.asList("SCRIPT", "STYLE"));

    private HeadElementUtils() {
    }

    public static String toHtmlString(HeadElement headElement) {
        String tagName = headElement.getTagName().toUpperCase();
        boolean isExpanedEmptyElements = EXPANDABLE_HEAD_ELEMENT_TAG_NAME_SET.contains(tagName);
        boolean isPreformattedTextContent = PREFORMATTED_HEAD_ELEMENT_TAG_NAME_SET.contains(tagName);
        return HeadElementUtils.toString(headElement, isExpanedEmptyElements, isPreformattedTextContent, false);
    }

    public static String toXhtmlString(HeadElement headElement) {
        return HeadElementUtils.toXhtmlString(headElement, false);
    }

    public static String toXhtmlString(HeadElement headElement, boolean commentedOutCDATAMarker) {
        String tagName = headElement.getTagName().toUpperCase();
        boolean isExpanedEmptyElements = EXPANDABLE_HEAD_ELEMENT_TAG_NAME_SET.contains(tagName);
        boolean isPreformattedTextContent = PREFORMATTED_HEAD_ELEMENT_TAG_NAME_SET.contains(tagName);
        return HeadElementUtils.toString(headElement, isExpanedEmptyElements, isPreformattedTextContent, true, commentedOutCDATAMarker);
    }

    public static String toString(HeadElement headElement, boolean isExpanedEmptyElements, boolean isPreformattedTextContent, boolean isPreformattedTextContentInCDATA) {
        return HeadElementUtils.toString(headElement, isExpanedEmptyElements, isPreformattedTextContent, isPreformattedTextContentInCDATA, false);
    }

    public static String toString(HeadElement headElement, boolean isExpanedEmptyElements, boolean isPreformattedTextContent, boolean isPreformattedTextContentInCDATA, boolean commentedOutCDATAMarker) {
        StringWriter writer = new StringWriter(80);
        try {
            HeadElementUtils.writeHeadElement(writer, headElement, isExpanedEmptyElements, isPreformattedTextContent, isPreformattedTextContentInCDATA, commentedOutCDATAMarker);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public static void writeHeadElement(Writer writer, HeadElement headElement, boolean isExpandEmptyElements, boolean isPreformattedTextContent, boolean isPreformattedTextContentInCDATA) throws IOException {
        HeadElementUtils.writeHeadElement(writer, headElement, isExpandEmptyElements, isPreformattedTextContent, isPreformattedTextContentInCDATA, false);
    }

    public static void writeHeadElement(Writer writer, HeadElement headElement, boolean isExpandEmptyElements, boolean isPreformattedTextContent, boolean isPreformattedTextContentInCDATA, boolean commentedOutCDATAMarker) throws IOException {
        String tagName = headElement.getTagName();
        writer.write(60);
        writer.write(tagName);
        for (Map.Entry entry : headElement.getAttributeMap().entrySet()) {
            writer.write(32);
            writer.write((String)entry.getKey());
            writer.write("=\"");
            writer.write(XmlUtils.encode((String)entry.getValue()));
            writer.write("\"");
        }
        if (!headElement.hasChildHeadElements()) {
            String textContent = headElement.getTextContent();
            if (!isExpandEmptyElements && (textContent == null || "".equals(textContent))) {
                writer.write("/>");
            } else {
                writer.write(62);
                if (textContent != null) {
                    if (isPreformattedTextContent) {
                        if (isPreformattedTextContentInCDATA) {
                            if (!"".equals(textContent)) {
                                if (commentedOutCDATAMarker) {
                                    String capitalizedTagName = tagName.toUpperCase();
                                    if ("SCRIPT".equals(capitalizedTagName)) {
                                        writer.write("\n//<![CDATA[\n");
                                        writer.write(textContent);
                                        writer.write("\n//]]>\n");
                                    } else if ("STYLE".equals(capitalizedTagName)) {
                                        writer.write("\n/*<![CDATA[*/\n");
                                        writer.write(textContent);
                                        writer.write("\n/*]]>*/\n");
                                    } else {
                                        writer.write("<![CDATA[");
                                        writer.write(textContent);
                                        writer.write("]]>");
                                    }
                                } else {
                                    writer.write("<![CDATA[");
                                    writer.write(textContent);
                                    writer.write("]]>");
                                }
                            }
                        } else {
                            writer.write(textContent);
                        }
                    } else {
                        writer.write(XmlUtils.encode(textContent));
                    }
                }
                writer.write("</");
                writer.write(tagName);
                writer.write(62);
            }
        } else {
            writer.write(">\n");
            for (HeadElement childHeadElement : headElement.getChildHeadElements()) {
                HeadElementUtils.writeHeadElement(writer, childHeadElement, isPreformattedTextContent, isExpandEmptyElements, isPreformattedTextContentInCDATA);
                writer.write(10);
            }
            writer.write("</");
            writer.write(tagName);
            writer.write(62);
        }
    }
}

