/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.util;

import java.util.Map;
import org.hippoecm.hst.util.KeyValue;

public class DefaultKeyValue<K, V>
implements KeyValue<K, V> {
    private K key;
    private V value;
    private boolean compareByKeyOnly;

    public DefaultKeyValue(K key, V value) {
        this(key, value, false);
    }

    public DefaultKeyValue(K key, V value, boolean compareByKeyOnly) {
        this.key = key;
        this.value = value;
        this.compareByKeyOnly = compareByKeyOnly;
    }

    public DefaultKeyValue(KeyValue<K, V> pair) {
        this(pair, false);
    }

    public DefaultKeyValue(KeyValue<K, V> pair, boolean compareByKeyOnly) {
        this(pair.getKey(), pair.getValue(), compareByKeyOnly);
    }

    public DefaultKeyValue(Map.Entry<K, V> entry) {
        this(entry, false);
    }

    public DefaultKeyValue(Map.Entry<K, V> entry, boolean compareByKeyOnly) {
        this(entry.getKey(), entry.getValue(), compareByKeyOnly);
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public K setKey(K key) {
        if (key == this) {
            throw new IllegalArgumentException("DefaultKeyValue may not contain itself as a key.");
        }
        K old = this.key;
        this.key = key;
        return old;
    }

    public V setValue(V value) {
        if (value == this) {
            throw new IllegalArgumentException("DefaultKeyValue may not contain itself as a value.");
        }
        V old = this.value;
        this.value = value;
        return old;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultKeyValue)) {
            return false;
        }
        DefaultKeyValue other = (DefaultKeyValue)obj;
        if (this.compareByKeyOnly) {
            return this.getKey() == null ? other.getKey() == null : this.getKey().equals(other.getKey());
        }
        return (this.getKey() == null ? other.getKey() == null : this.getKey().equals(other.getKey())) && (this.getValue() == null ? other.getValue() == null : this.getValue().equals(other.getValue()));
    }

    public int hashCode() {
        return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
    }
}

