/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AnnotationsScanner {
    private static final Map<String, List<MethodAnnotations>> alreadyInspectedClasses = new ConcurrentHashMap<String, List<MethodAnnotations>>();

    public static Map<Method, Set<Annotation>> getMethodAnnotations(Class<?> clazz) {
        HashMap<Method, Set<Annotation>> methodAnnotations = new HashMap<Method, Set<Annotation>>();
        List<MethodAnnotations> methodAnnotationsList = AnnotationsScanner.getMethodAnnotationsList(clazz);
        for (MethodAnnotations methodAnnotation : methodAnnotationsList) {
            Set overLoadedMethodPresent = (Set)methodAnnotations.get(methodAnnotation.getMethod());
            if (overLoadedMethodPresent != null) {
                overLoadedMethodPresent.addAll(methodAnnotation.getAnnotations());
                continue;
            }
            methodAnnotations.put(methodAnnotation.getMethod(), methodAnnotation.getAnnotations());
        }
        return methodAnnotations;
    }

    public static List<MethodAnnotations> getMethodAnnotationsList(Class<?> clazz) {
        List<MethodAnnotations> cached = alreadyInspectedClasses.get(clazz.getName());
        if (cached != null) {
            return cached;
        }
        ArrayList<MethodAnnotations> methodAnnotations = new ArrayList<MethodAnnotations>();
        for (Method method : clazz.getMethods()) {
            HashSet<Annotation> allAnnotations = new HashSet<Annotation>();
            AnnotationsScanner.populateAnnotationsForMethod(method, allAnnotations);
            if (allAnnotations.isEmpty()) continue;
            methodAnnotations.add(new MethodAnnotations(method, allAnnotations));
        }
        alreadyInspectedClasses.put(clazz.getName(), methodAnnotations);
        return methodAnnotations;
    }

    private static void populateAnnotationsForMethod(Method method, Set<Annotation> allAnnotations) {
        Annotation[] annotations;
        if (method == null) {
            return;
        }
        for (Annotation annotation : annotations = method.getAnnotations()) {
            allAnnotations.add(annotation);
        }
        Class<?> superC = method.getDeclaringClass().getSuperclass();
        if (superC != null && Object.class != superC) {
            try {
                Method superMethod = superC.getMethod(method.getName(), method.getParameterTypes());
                AnnotationsScanner.populateAnnotationsForMethod(superMethod, allAnnotations);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        for (Class<?> interfaze : method.getDeclaringClass().getInterfaces()) {
            try {
                Method superMethod = interfaze.getMethod(method.getName(), method.getParameterTypes());
                AnnotationsScanner.populateAnnotationsForMethod(superMethod, allAnnotations);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
    }

    public static Method doGetAnnotatedMethod(Method method, Class<? extends Annotation> clazz) {
        if (method == null) {
            return method;
        }
        Annotation annotation = method.getAnnotation(clazz);
        if (annotation != null) {
            return method;
        }
        Class<?> superC = method.getDeclaringClass().getSuperclass();
        if (superC != null && Object.class != superC) {
            try {
                Method superMethod = AnnotationsScanner.doGetAnnotatedMethod(superC.getMethod(method.getName(), method.getParameterTypes()), clazz);
                if (superMethod != null) {
                    return superMethod;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        for (Class<?> i : method.getDeclaringClass().getInterfaces()) {
            try {
                Method superMethod = AnnotationsScanner.doGetAnnotatedMethod(i.getMethod(method.getName(), method.getParameterTypes()), clazz);
                if (superMethod == null) continue;
                return superMethod;
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        return null;
    }

    public static class MethodAnnotations {
        private final Method method;
        private final Set<Annotation> annotations;

        private MethodAnnotations(Method method, Set<Annotation> annotations) {
            if (annotations == null) {
                throw new IllegalArgumentException("Set not allowed to be null for MethodAnnotations");
            }
            this.method = method;
            this.annotations = annotations;
        }

        public Method getMethod() {
            return this.method;
        }

        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }
    }
}

