/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.hippoecm.hst.core.container.ComponentManager;
import org.hippoecm.hst.core.container.HstRequestProcessor;
import org.hippoecm.hst.logging.Logger;
import org.hippoecm.hst.logging.LoggerFactory;
import org.hippoecm.hst.util.NOOPLogger;

public class HstServices {
    private static final String LOGGER_FACTORY_COMPONENT_NAME = LoggerFactory.class.getName();
    private static boolean available;
    private static ComponentManager componentManager;
    private static NOOPLogger noopLogger;
    private static String HST_VERSION;

    private HstServices() {
    }

    public static void setComponentManager(ComponentManager compManager) {
        componentManager = compManager;
        available = componentManager != null;
    }

    public static ComponentManager getComponentManager() {
        return componentManager;
    }

    public static boolean isAvailable() {
        return available;
    }

    public static HstRequestProcessor getRequestProcessor() {
        return (HstRequestProcessor)componentManager.getComponent(HstRequestProcessor.class.getName());
    }

    public static Logger getLogger(String loggerName) {
        if (HstServices.isAvailable()) {
            return ((LoggerFactory)HstServices.getComponentManager().getComponent(LOGGER_FACTORY_COMPONENT_NAME)).getLogger(loggerName);
        }
        return noopLogger;
    }

    public static Logger getLogger(String loggerName, String fqcn) {
        if (HstServices.isAvailable()) {
            return ((LoggerFactory)HstServices.getComponentManager().getComponent(LOGGER_FACTORY_COMPONENT_NAME)).getLogger(loggerName, fqcn);
        }
        return noopLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImplementationVersion() {
        if (HST_VERSION != null) {
            return HST_VERSION;
        }
        Logger log = HstServices.getLogger(HstServices.class.getName());
        InputStream istream = null;
        try {
            Manifest manifest;
            Attributes atts;
            StringBuffer sb = new StringBuffer();
            String[] classElements = HstServices.class.getName().split("\\.");
            for (int i = 0; i < classElements.length - 1; ++i) {
                sb.append("../");
            }
            sb.append("META-INF/MANIFEST.MF");
            URL classResource = HstServices.class.getResource(classElements[classElements.length - 1] + ".class");
            URL manifestURL = new URL(classResource, new String(sb));
            istream = manifestURL.openStream();
            if (istream != null && (atts = (manifest = new Manifest(istream)).getMainAttributes()).getValue("Implementation-Version") != null) {
                String string = HST_VERSION = atts.getValue("Implementation-Version");
                return string;
            }
        }
        catch (MalformedURLException ex) {
            log.warn("Cannot get HST Version", (Throwable)ex);
        }
        catch (IOException ex) {
            log.warn("Cannot get HST Version: {}", (Object)ex.getMessage());
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e) {}
            }
        }
        HST_VERSION = "Undefined";
        return HST_VERSION;
    }

    static {
        noopLogger = new NOOPLogger();
    }
}

