/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.security;

import java.lang.reflect.Method;
import java.util.Set;
import org.hippoecm.hst.logging.Logger;
import org.hippoecm.hst.site.HstServices;

public class PolicyContextWrapper {
    private static Class<?> policyContextClazz;
    private static Method getContextMethod;
    private static Method getContextIDMethod;
    private static Method getHandlerKeysMethod;
    private static Method setContextIDMethod;
    private static Method setHandlerDataMethod;

    private PolicyContextWrapper() {
    }

    public static boolean isAvailable() {
        return policyContextClazz != null;
    }

    public static Object getContext(String key) {
        if (getContextMethod != null) {
            try {
                return getContextMethod.invoke(policyContextClazz, key);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static String getContextID() {
        if (getContextIDMethod != null) {
            try {
                return (String)getContextIDMethod.invoke(policyContextClazz, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Set getHandlerKeys() {
        if (getHandlerKeysMethod != null) {
            try {
                return (Set)getHandlerKeysMethod.invoke(policyContextClazz, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static void setContextID(String contextID) {
        if (setContextIDMethod != null) {
            try {
                setContextIDMethod.invoke(policyContextClazz, contextID);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void setHandlerData(Object data) {
        if (setHandlerDataMethod != null) {
            try {
                setHandlerDataMethod.invoke(policyContextClazz, data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        try {
            policyContextClazz = Class.forName("javax.security.jacc.PolicyContext");
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        if (policyContextClazz != null) {
            try {
                getContextMethod = policyContextClazz.getMethod("getContext", String.class);
                getContextIDMethod = policyContextClazz.getMethod("getContextID", new Class[0]);
                getHandlerKeysMethod = policyContextClazz.getMethod("getHandlerKeys", new Class[0]);
                setContextIDMethod = policyContextClazz.getMethod("setContextID", String.class);
                setHandlerDataMethod = policyContextClazz.getMethod("setHandlerData", Object.class);
            }
            catch (Throwable th) {
                Logger logger = HstServices.getLogger("org.hippoecm.hst.security.PolicyContextWrapper");
                logger.warn("Failed to load methods of javax.security.jacc.PolicyContext", th);
            }
        }
    }
}

