/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.security;

import java.security.AccessControlContext;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;

public class HstSubject {
    private static ThreadLocal<Subject> tlSubject = new ThreadLocal();

    private HstSubject() {
    }

    public static Subject getSubject(AccessControlContext acc) {
        Subject subject = tlSubject.get();
        if (subject == null) {
            subject = Subject.getSubject(acc);
        }
        return subject;
    }

    public static <T> T doAs(Subject subjectInput, PrivilegedAction<T> action) {
        Subject subject = subjectInput;
        if (subject == null) {
            subject = HstSubject.getSubject(null);
        }
        tlSubject.set(subject);
        return Subject.doAs(subject, action);
    }

    public static <T> T doAs(Subject subjectInput, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        Subject subject = subjectInput;
        if (subject == null) {
            subject = HstSubject.getSubject(null);
        }
        tlSubject.set(subject);
        return Subject.doAs(subject, action);
    }

    public static <T> T doAsPrivileged(Subject subjectInput, PrivilegedAction<T> action, AccessControlContext acc) {
        Subject subject = subjectInput;
        if (subject == null) {
            subject = HstSubject.getSubject(acc);
        }
        tlSubject.set(subject);
        return Subject.doAsPrivileged(subject, action, acc);
    }

    public static <T> T doAsPrivileged(Subject subjectInput, PrivilegedExceptionAction<T> action, AccessControlContext acc) throws PrivilegedActionException {
        Subject subject = subjectInput;
        if (subject == null) {
            subject = HstSubject.getSubject(acc);
        }
        tlSubject.set(subject);
        return Subject.doAsPrivileged(subject, action, acc);
    }

    public static void clearSubject() {
        tlSubject.remove();
    }
}

