/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.resourcebundle;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.hippoecm.hst.core.component.HstRequest;
import org.hippoecm.hst.resourcebundle.ResourceBundleRegistry;
import org.hippoecm.hst.site.HstServices;
import org.hippoecm.hst.util.HstRequestUtils;

public class ResourceBundleUtils {
    private ResourceBundleUtils() {
    }

    public static ResourceBundle getBundle(HttpServletRequest servletRequest, String basename, Locale locale) {
        return ResourceBundleUtils.getBundle(servletRequest, basename, locale, true);
    }

    public static ResourceBundle getBundle(HttpServletRequest servletRequest, String basename, Locale locale, boolean fallbackToJavaResourceBundle) {
        ResourceBundleRegistry resourceBundleRegistry;
        ResourceBundle bundle = null;
        HstRequest hstRequest = HstRequestUtils.getHstRequest(servletRequest);
        if (hstRequest != null && (resourceBundleRegistry = (ResourceBundleRegistry)HstServices.getComponentManager().getComponent(ResourceBundleRegistry.class.getName())) != null) {
            boolean preview = hstRequest.getRequestContext().isPreview();
            if (locale == null) {
                bundle = preview ? resourceBundleRegistry.getBundleForPreview(basename) : resourceBundleRegistry.getBundle(basename);
            } else {
                ResourceBundle resourceBundle = bundle = preview ? resourceBundleRegistry.getBundleForPreview(basename, locale) : resourceBundleRegistry.getBundle(basename, locale);
            }
        }
        if (bundle == null && fallbackToJavaResourceBundle) {
            bundle = locale == null ? ResourceBundle.getBundle(basename, Locale.getDefault(), Thread.currentThread().getContextClassLoader()) : ResourceBundle.getBundle(basename, locale, Thread.currentThread().getContextClassLoader());
        }
        return bundle;
    }
}

