/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.diagnosis;

import org.hippoecm.hst.diagnosis.DefaultTaskImpl;
import org.hippoecm.hst.diagnosis.NOOPTaskImpl;
import org.hippoecm.hst.diagnosis.Task;

public class HDC {
    public static final Task NOOP_TASK = new NOOPTaskImpl();
    private static ThreadLocal<Task> tlRootTask = new ThreadLocal();
    private static ThreadLocal<Task> tlCurrentTask = new ThreadLocal();

    private HDC() {
    }

    public static Task start(String name) {
        Task rootTask = tlRootTask.get();
        if (rootTask != null) {
            throw new IllegalStateException("The root task was already started.");
        }
        rootTask = new DefaultTaskImpl(null, name);
        tlRootTask.set(rootTask);
        return rootTask;
    }

    public static boolean isStarted() {
        return tlRootTask.get() != null;
    }

    public static Task getRootTask() {
        Task rootTask = tlRootTask.get();
        return rootTask != null ? rootTask : NOOP_TASK;
    }

    public static Task getCurrentTask() {
        Task current = tlCurrentTask.get();
        if (current != null) {
            return current;
        }
        return HDC.getRootTask();
    }

    public static void setCurrentTask(Task currentTask) {
        tlCurrentTask.set(currentTask);
    }

    public static void cleanUp() {
        tlCurrentTask.remove();
        tlRootTask.remove();
    }
}

