/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.diagnosis;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hippoecm.hst.diagnosis.HDC;
import org.hippoecm.hst.diagnosis.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultTaskImpl
implements Task {
    private static final Logger log = LoggerFactory.getLogger(DefaultTaskImpl.class);
    private final String name;
    private Map<String, Object> attributes;
    private final Task parentTask;
    private List<Task> childTasks;
    private long startTimeMillis;
    private long durationTimeMillis = -1L;
    private boolean stopped;

    DefaultTaskImpl(Task parentTask, String name) {
        this.parentTask = parentTask;
        this.name = name;
        this.startTimeMillis = System.currentTimeMillis();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getAttributeMap() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    public Enumeration<String> getAttributeNames() {
        if (this.attributes != null) {
            return Collections.enumeration(this.attributes.keySet());
        }
        List emptyAttrNames = Collections.emptyList();
        return Collections.enumeration(emptyAttrNames);
    }

    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, Object>();
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public Object removeAttribute(String key) {
        if (this.attributes != null) {
            return this.attributes.remove(key);
        }
        return null;
    }

    public Task getParentTask() {
        return this.parentTask;
    }

    public Task startSubtask(String name) {
        if (this.stopped) {
            throw new IllegalStateException("The task was already stopped.");
        }
        if (this.childTasks == null) {
            this.childTasks = new LinkedList<Task>();
        }
        DefaultTaskImpl childTask = new DefaultTaskImpl(this, name);
        this.childTasks.add(childTask);
        HDC.setCurrentTask(childTask);
        return childTask;
    }

    public void stop() {
        if (this.stopped) {
            log.warn("Task '{}' was already stopped.", (Object)this.name);
            return;
        }
        this.stopped = true;
        this.durationTimeMillis = System.currentTimeMillis() - this.startTimeMillis;
        HDC.setCurrentTask(this.parentTask);
    }

    public Collection<Task> getChildTasks() {
        if (this.childTasks == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.childTasks);
    }

    public boolean isRunning() {
        return !this.stopped;
    }

    public long getDurationTimeMillis() {
        if (!this.stopped) {
            log.warn("Task '{}' was not stopped hence duration time unknown.", (Object)this.name);
        }
        return this.durationTimeMillis;
    }
}

