/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.sitemenu;

import java.util.ArrayList;
import java.util.List;
import org.hippoecm.hst.core.sitemenu.AbstractMenuItem;
import org.hippoecm.hst.core.sitemenu.EditableMenu;
import org.hippoecm.hst.core.sitemenu.EditableMenuItem;
import org.hippoecm.hst.core.sitemenu.HstSiteMenuItem;
import org.hippoecm.hst.site.HstServices;

public class EditableMenuItemImpl
extends AbstractMenuItem
implements EditableMenuItem {
    private static final long serialVersionUID = 1L;
    private EditableMenu editableMenu;
    private List<EditableMenuItem> childMenuItems = new ArrayList<EditableMenuItem>();
    private EditableMenuItem parentItem;

    public EditableMenuItemImpl(EditableMenuItem parentItem) {
        if (parentItem == null) {
            HstServices.getLogger(this.getClass().getName()).error("Cannot add a Editable menu item when parent item is null");
            return;
        }
        this.parentItem = parentItem;
        this.editableMenu = parentItem.getEditableMenu();
    }

    public EditableMenuItemImpl(EditableMenu editableMenu, EditableMenuItem parentItem, HstSiteMenuItem siteMenuItem) {
        this.editableMenu = editableMenu;
        this.parentItem = parentItem;
        this.name = siteMenuItem.getName();
        this.depth = siteMenuItem.getDepth();
        this.repositoryBased = siteMenuItem.isRepositoryBased();
        this.properties = siteMenuItem.getProperties();
        this.hstLink = siteMenuItem.getHstLink();
        this.externalLink = siteMenuItem.getExternalLink();
        this.expanded = siteMenuItem.isExpanded();
        this.selected = siteMenuItem.isSelected();
        for (HstSiteMenuItem childMenuItem : siteMenuItem.getChildMenuItems()) {
            this.childMenuItems.add(new EditableMenuItemImpl(this.editableMenu, this, childMenuItem));
        }
    }

    public List<EditableMenuItem> getChildMenuItems() {
        return this.childMenuItems;
    }

    public void addChildMenuItem(EditableMenuItem childMenuItem) {
        this.childMenuItems.add(childMenuItem);
        if (childMenuItem.isSelected() || childMenuItem.isExpanded()) {
            this.setExpanded(true);
        }
        if (childMenuItem.isSelected()) {
            this.editableMenu.setSelectedMenuItem(childMenuItem);
        }
    }

    public EditableMenu getEditableMenu() {
        return this.editableMenu;
    }

    public EditableMenuItem getParentItem() {
        return this.parentItem;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
        if (this.parentItem != null) {
            this.parentItem.setExpanded(expanded);
        }
    }
}

