/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.sitemenu;

import java.util.ArrayList;
import java.util.List;
import org.hippoecm.hst.core.sitemenu.AbstractMenu;
import org.hippoecm.hst.core.sitemenu.EditableMenu;
import org.hippoecm.hst.core.sitemenu.EditableMenuItem;
import org.hippoecm.hst.core.sitemenu.EditableMenuItemImpl;
import org.hippoecm.hst.core.sitemenu.HstSiteMenu;
import org.hippoecm.hst.core.sitemenu.HstSiteMenuItem;
import org.hippoecm.hst.core.sitemenu.HstSiteMenus;

public class EditableMenuImpl
extends AbstractMenu
implements EditableMenu {
    private static final long serialVersionUID = 1L;
    private HstSiteMenus hstSiteMenus;
    private List<EditableMenuItem> editableMenuItems = new ArrayList<EditableMenuItem>();
    private EditableMenuItem selectedMenuItem;

    public EditableMenuImpl(HstSiteMenu hstSiteMenu) {
        this.name = hstSiteMenu.getName();
        this.hstSiteMenus = hstSiteMenu.getHstSiteMenus();
        this.expanded = hstSiteMenu.isExpanded();
        for (HstSiteMenuItem siteMenuItem : hstSiteMenu.getSiteMenuItems()) {
            this.editableMenuItems.add(new EditableMenuItemImpl(this, null, siteMenuItem));
        }
    }

    public List<EditableMenuItem> getMenuItems() {
        return this.editableMenuItems;
    }

    public EditableMenuItem getDeepestExpandedItem() {
        if (this.selectedMenuItem != null) {
            return this.selectedMenuItem;
        }
        if (!this.expanded) {
            return null;
        }
        for (EditableMenuItem item : this.editableMenuItems) {
            if (!item.isExpanded()) continue;
            return this.traverseToDeepestExpandedItem(item);
        }
        return null;
    }

    private EditableMenuItem traverseToDeepestExpandedItem(EditableMenuItem item) {
        for (EditableMenuItem child : item.getChildMenuItems()) {
            if (!child.isExpanded()) continue;
            return this.traverseToDeepestExpandedItem(child);
        }
        return item;
    }

    public HstSiteMenus getHstSiteMenus() {
        return this.hstSiteMenus;
    }

    public EditableMenuItem getSelectMenuItem() {
        return this.selectedMenuItem;
    }

    public void setSelectedMenuItem(EditableMenuItem selectedMenuItem) {
        this.selectedMenuItem = selectedMenuItem;
    }
}

