/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.sitemenu;

import java.util.Map;
import org.hippoecm.hst.configuration.hosting.NotFoundException;
import org.hippoecm.hst.core.component.HstRequest;
import org.hippoecm.hst.core.linking.HstLink;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.core.request.ResolvedSiteMapItem;
import org.hippoecm.hst.core.sitemenu.CommonMenuItem;
import org.hippoecm.hst.site.HstServices;
import org.hippoecm.repository.api.NodeNameCodec;

public abstract class AbstractMenuItem
implements CommonMenuItem {
    private ResolvedSiteMapItemWrapper resolvedSiteMapItem;
    protected int depth;
    protected boolean repositoryBased;
    protected Map<String, Object> properties;
    protected HstLink hstLink;
    protected String externalLink;
    protected String name;
    protected boolean expanded;
    protected boolean selected;

    public int getDepth() {
        return this.depth;
    }

    public boolean isRepositoryBased() {
        return this.repositoryBased;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public HstLink getHstLink() {
        return this.hstLink;
    }

    public String getExternalLink() {
        return this.externalLink;
    }

    public String getName() {
        return NodeNameCodec.decode((String)this.name);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public ResolvedSiteMapItem resolveToSiteMapItem(HstRequest request) {
        if (this.resolvedSiteMapItem != null) {
            return this.resolvedSiteMapItem.resolvedItem;
        }
        if (this.getHstLink() == null || this.getHstLink().getPath() == null || "".equals(this.getHstLink().getPath())) {
            HstServices.getLogger(this.getClass().getName()).warn("Cannot resolve to sitemap item because HstLink is null or empty. Return null");
            return null;
        }
        HstRequestContext ctx = request.getRequestContext();
        try {
            this.resolvedSiteMapItem = new ResolvedSiteMapItemWrapper(ctx.getSiteMapMatcher().match(this.getHstLink().getPath(), ctx.getResolvedSiteMapItem().getResolvedMount()));
        }
        catch (NotFoundException e) {
            HstServices.getLogger(this.getClass().getName()).warn("Cannot resolve to sitemap item because '{}'. Return null.", (Object)e.getMessage());
            return null;
        }
        return this.resolvedSiteMapItem.resolvedItem;
    }

    private static class ResolvedSiteMapItemWrapper {
        private ResolvedSiteMapItem resolvedItem;

        ResolvedSiteMapItemWrapper(ResolvedSiteMapItem resolvedItem) {
            this.resolvedItem = resolvedItem;
        }
    }
}

