/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.linking;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.core.linking.ResourceContainer;
import org.hippoecm.hst.logging.Logger;
import org.hippoecm.hst.site.HstServices;

public abstract class AbstractResourceContainer
implements ResourceContainer {
    private static final String LOGGER_CATEGORY_NAME = AbstractResourceContainer.class.getName();
    private Map<String, String> mappings = new HashMap<String, String>();
    private String primaryItem;

    public void setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    public Map<String, String> getMappings() {
        return this.mappings;
    }

    public void setPrimaryItem(String primaryItem) {
        this.primaryItem = primaryItem;
    }

    public String getPrimaryItem() {
        return this.primaryItem;
    }

    public String resolveToPathInfo(Node resourceContainerNode, Node resourceNode, Mount mount) {
        Logger log = HstServices.getLogger(LOGGER_CATEGORY_NAME);
        try {
            if (this.primaryItem == null && (this.mappings == null || this.mappings.isEmpty())) {
                return resourceNode.getPath();
            }
            if (resourceNode.getName().equals(this.primaryItem)) {
                Node parentContainer = resourceContainerNode.getParent();
                if (!parentContainer.isNodeType("hippo:handle")) {
                    return resourceContainerNode.getPath();
                }
                return parentContainer.getPath();
            }
            String mapTo = this.mappings.get(resourceNode.getName());
            if (mapTo != null) {
                Node parentContainer = resourceContainerNode.getParent();
                if (!parentContainer.isNodeType("hippo:handle")) {
                    resourceContainerNode.getPath();
                }
                String path = parentContainer.getPath();
                if (mapTo != null && !"".equals(mapTo)) {
                    path = "/" + mapTo + path;
                }
                return path;
            }
            log.warn("'{}' is not mapped in mappings. Return null", (Object)resourceNode.getName());
            return null;
        }
        catch (RepositoryException e) {
            log.error("RepositoryException: Return null", (Throwable)e);
            return null;
        }
    }

    public Node resolveToResourceNode(Session session, String pathInfo) {
        Logger log = HstServices.getLogger(LOGGER_CATEGORY_NAME);
        String actualPath = pathInfo;
        String[] elems = actualPath.substring(1).split("/");
        String mapTo = null;
        for (Map.Entry<String, String> mapping : this.mappings.entrySet()) {
            if (!mapping.getValue().equals(elems[0])) continue;
            mapTo = mapping.getKey();
            break;
        }
        if (mapTo != null) {
            actualPath = actualPath.substring(1).substring(elems[0].length());
        }
        try {
            Item item = session.getItem(actualPath);
            if (!item.isNode()) {
                log.debug("path '{}' does not point to a node", (Object)actualPath);
                return null;
            }
            Node node = (Node)item;
            if (node.isNodeType("hippo:resource")) {
                log.debug("Resource Node found at '{}'. Return resource", (Object)actualPath);
                return node;
            }
            if (node.isNodeType("hippo:handle")) {
                try {
                    node = node.getNode(node.getName());
                }
                catch (PathNotFoundException e) {
                    log.warn("Cannot return binary for a handle with no hippo document. Return null");
                    return null;
                }
            }
            if (node.isNodeType(this.getNodeType())) {
                Item primItem;
                Node resourceNode;
                if (mapTo != null && node.hasNode(mapTo)) {
                    resourceNode = node.getNode(mapTo);
                    if (resourceNode.isNodeType("hippo:resource")) {
                        return resourceNode;
                    }
                    log.debug("Expected resource node of type '{}' but found node of type '{}'. Try to return the primary item from this resource container.", (Object)"hippo:resource", (Object)resourceNode.getPrimaryNodeType().getName());
                }
                if (node.hasNode(this.primaryItem)) {
                    resourceNode = node.getNode(this.primaryItem);
                    if (resourceNode.isNodeType("hippo:resource")) {
                        return resourceNode;
                    }
                    log.debug("Expected resource node of type '{}' but found node of type '{}'. Try to return the primary jcr item (primarry item as in cnd).", (Object)"hippo:resource", (Object)resourceNode.getPrimaryNodeType().getName());
                }
                if ((primItem = node.getPrimaryItem()).isNode()) {
                    Node resourceNode2 = (Node)primItem;
                    if (resourceNode2.isNodeType("hippo:resource")) {
                        return resourceNode2;
                    }
                    log.debug("Expected resource node of type '{}' but found node of type '{}'. Return null.", (Object)"hippo:resource", (Object)resourceNode2.getPrimaryNodeType().getName());
                } else {
                    log.debug("Primary jcr item was a property where we expected a node of type '{}'. Return null", (Object)"hippo:resource");
                }
                return null;
            }
            log.debug("'{}' is not a resource container that is applicable for node of type '{}' at path :" + node.getPath() + ". Return null", (Object)this.getClass().getName(), (Object)node.getPrimaryNodeType().getName());
        }
        catch (PathNotFoundException e) {
            log.debug("Cannot find resource node for path '{}' beloning to pathInfo '{}'", (Object)actualPath, (Object)pathInfo);
        }
        catch (RepositoryException e) {
            log.warn("RepositoryException: '{}'", (Object)e.getMessage());
        }
        return null;
    }
}

